/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.data.recipebuilder.AlchemicalCauldronRecipeBuilder;
import de.teamlapen.vampirism.data.recipebuilder.AlchemyTableRecipeBuilder;
import de.teamlapen.vampirism.data.recipebuilder.ShapedWeaponTableRecipeBuilder;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.items.OilBottleItem;
import de.teamlapen.vampirism.util.NBTIngredient;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModOils;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.data.ModBlockFamilies;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class RecipeGenerator
extends VanillaRecipeProvider {
    protected static final ImmutableList<ItemLike> SILVER_SMELTABLES = ImmutableList.of((Object)((ItemLike)ModBlocks.SILVER_ORE.get()), (Object)((ItemLike)ModBlocks.DEEPSLATE_SILVER_ORE.get()), (Object)((ItemLike)ModItems.RAW_SILVER.get()));

    public RecipeGenerator(@NotNull PackOutput packOutput) {
        super(packOutput);
    }

    private static ResourceLocation modId(String name) {
        return new ResourceLocation("werewolves", name);
    }

    protected void buildRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        TagKey sticks = Tags.Items.RODS_WOODEN;
        TagKey<Item> silver_ingot = ModTags.Items.SILVER_INGOT;
        TagKey<Item> silver_nugget = ModTags.Items.SILVER_NUGGET;
        TagKey<Item> raw_silver = ModTags.Items.RAW_MATERIALS_SILVER;
        TagKey iron_ingot = Tags.Items.INGOTS_IRON;
        TagKey feathers = Tags.Items.FEATHERS;
        ItemLike crossbow_arrow = (ItemLike)ModItems.V.CROSSBOW_ARROW_NORMAL.get();
        TagKey planks = ItemTags.PLANKS;
        TagKey diamond = Tags.Items.GEMS_DIAMOND;
        TagKey obsidian = Tags.Items.OBSIDIAN;
        ItemLike wolfsbane_diffuser_core = (ItemLike)ModItems.WOLFSBANE_DIFFUSER_CORE.get();
        ItemLike wolfsbane_diffuser_core_improved = (ItemLike)ModItems.WOLFSBANE_DIFFUSER_CORE_IMPROVED.get();
        ItemLike wolfsbane_diffuser = (ItemLike)ModBlocks.WOLFSBANE_DIFFUSER.get();
        TagKey wool = ItemTags.WOOL;
        ItemLike wolfsbane = (ItemLike)ModBlocks.WOLFSBANE.get();
        ItemLike pelt = (ItemLike)ModItems.PELT.get();
        ItemLike dark_pelt = (ItemLike)ModItems.DARK_PELT.get();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BONE, (int)2).requires((ItemLike)ModItems.CRACKED_BONE.get()).unlockedBy("has_broken_bone", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.CRACKED_BONE.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PURPLE_DYE).requires((ItemLike)ModBlocks.WOLFSBANE.get()).unlockedBy("has_wolfsbane", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModBlocks.WOLFSBANE.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_HOE.get())).pattern("XX").pattern(" #").pattern(" #").define(Character.valueOf('#'), sticks).unlockedBy("has_sticks", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)sticks)).define(Character.valueOf('X'), silver_ingot).unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_SHOVEL.get())).pattern("X").pattern("#").pattern("#").define(Character.valueOf('#'), sticks).unlockedBy("has_sticks", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)sticks)).define(Character.valueOf('X'), silver_ingot).unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_SWORD.get())).pattern("X").pattern("X").pattern("#").define(Character.valueOf('#'), sticks).unlockedBy("has_sticks", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)sticks)).define(Character.valueOf('X'), silver_ingot).unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_AXE.get())).pattern("XX").pattern("X#").pattern(" #").define(Character.valueOf('#'), sticks).unlockedBy("has_sticks", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)sticks)).define(Character.valueOf('X'), silver_ingot).unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_PICKAXE.get())).pattern("XXX").pattern(" # ").pattern(" # ").define(Character.valueOf('#'), sticks).unlockedBy("has_sticks", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)sticks)).define(Character.valueOf('X'), silver_ingot).unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.STONE_ALTAR.get())).pattern("S S").pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)Items.STONE_BRICKS).unlockedBy("has_stone_bricks", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)Items.STONE_BRICKS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.STONE_ALTAR_FIRE_BOWL.get())).pattern("SPS").pattern("SSS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)Items.STONE_BRICKS).unlockedBy("has_stone_bricks", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)Items.STONE_BRICKS)).define(Character.valueOf('P'), ItemTags.PLANKS).unlockedBy("has_planks", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)ItemTags.PLANKS)).save(consumer);
        RecipeGenerator.nineBlockStorageRecipes(consumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_INGOT.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SILVER_BLOCK.get()));
        RecipeGenerator.nineBlockStorageRecipes(consumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.RAW_SILVER.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.RAW_SILVER_BLOCK.get()));
        RecipeGenerator.nineBlockStorageRecipesWithCustomPacking(consumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_NUGGET.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_INGOT.get()), (String)"werewolves:silver_ingot_from_nuggets", (String)"silver_ingot");
        RecipeGenerator.oreSmelting(consumer, SILVER_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_INGOT.get()), (float)0.7f, (int)200, (String)"silver_ingot");
        RecipeGenerator.oreBlasting(consumer, SILVER_SMELTABLES, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_INGOT.get()), (float)0.7f, (int)100, (String)"silver_ingot");
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SILVER_AXE.get(), (ItemLike)ModItems.SILVER_HOE.get(), (ItemLike)ModItems.SILVER_PICKAXE.get(), (ItemLike)ModItems.SILVER_SHOVEL.get(), (ItemLike)ModItems.SILVER_SWORD.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_NUGGET.get()), (float)0.1f, (int)200).unlockedBy("has_silver_axe", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_AXE.get()))).unlockedBy("has_silver_hoe", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_HOE.get()))).unlockedBy("has_silver_pickaxe", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_PICKAXE.get()))).unlockedBy("has_silver_shovel", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_SHOVEL.get()))).unlockedBy("has_silver_sword", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_SWORD.get()))).save(consumer, RecipeGenerator.getSmeltingRecipeName((ItemLike)((ItemLike)ModItems.SILVER_NUGGET.get())));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SILVER_AXE.get(), (ItemLike)ModItems.SILVER_HOE.get(), (ItemLike)ModItems.SILVER_PICKAXE.get(), (ItemLike)ModItems.SILVER_SHOVEL.get(), (ItemLike)ModItems.SILVER_SWORD.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_NUGGET.get()), (float)0.1f, (int)100).unlockedBy("has_silver_axe", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_AXE.get()))).unlockedBy("has_silver_hoe", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_HOE.get()))).unlockedBy("has_silver_pickaxe", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_PICKAXE.get()))).unlockedBy("has_silver_shovel", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_SHOVEL.get()))).unlockedBy("has_silver_sword", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.SILVER_SWORD.get()))).save(consumer, RecipeGenerator.getBlastingRecipeName((ItemLike)((ItemLike)ModItems.SILVER_NUGGET.get())));
        ShapedWeaponTableRecipeBuilder.shapedWeaponTable((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CROSSBOW_ARROW_SILVER_BOLT.get()), (int)3).pattern(" X ").pattern("XYX").pattern(" S ").pattern(" F ").lava(1).define(Character.valueOf('S'), sticks).unlockedBy("hasSticks", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)sticks)).define(Character.valueOf('X'), silver_nugget).unlockedBy("has_silver_nugget", (CriterionTriggerInstance)RecipeGenerator.has(silver_nugget)).define(Character.valueOf('F'), feathers).unlockedBy("has_feathers", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)feathers)).define(Character.valueOf('Y'), iron_ingot).unlockedBy("has_iron", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)iron_ingot)).unlockedBy("has_crossbow_arrow", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)crossbow_arrow)).save(consumer, RecipeGenerator.modId("crossbow_arrow_silver_bolt"));
        AlchemyTableRecipeBuilder.builder(ModOils.SILVER_OIL_1).bloodOilIngredient().input(Ingredient.of(ModTags.Items.SILVER_INGOT)).withCriterion("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(ModTags.Items.SILVER_INGOT)).build(consumer, RecipeGenerator.modId("silver_oil_1"));
        AlchemyTableRecipeBuilder.builder(ModOils.SILVER_OIL_2).ingredient((Ingredient)new NBTIngredient(new ItemStack[]{((OilBottleItem)de.teamlapen.vampirism.core.ModItems.OIL_BOTTLE.get()).withOil((IOil)ModOils.SILVER_OIL_1.get())})).withCriterion("has_silver_oil_1", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)de.teamlapen.vampirism.core.ModItems.OIL_BOTTLE.get()))).input(Ingredient.of(ModTags.Items.SILVER_INGOT)).withCriterion("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(ModTags.Items.SILVER_INGOT)).build(consumer, RecipeGenerator.modId("silver_oil_2"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.SILVER_HELMET.get())).define(Character.valueOf('X'), silver_ingot).pattern("XXX").pattern("X X").unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.SILVER_CHESTPLATE.get())).define(Character.valueOf('X'), silver_ingot).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.SILVER_LEGGINGS.get())).define(Character.valueOf('X'), silver_ingot).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.SILVER_BOOTS.get())).define(Character.valueOf('X'), silver_ingot).pattern("X X").pattern("X X").unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.YELLOW_DYE).requires((ItemLike)ModBlocks.DAFFODIL.get()).unlockedBy("has_daffodil", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModBlocks.DAFFODIL.get()))).save(consumer, RecipeGenerator.modId("daffodil_yellow_dye"));
        RecipeGenerator.generateRecipes(consumer, (BlockFamily)ModBlockFamilies.JACARANDA_PLANKS);
        RecipeGenerator.generateRecipes(consumer, (BlockFamily)ModBlockFamilies.MAGIC_PLANKS);
        RecipeGenerator.planksFromLog(consumer, (ItemLike)((ItemLike)ModBlocks.JACARANDA_PLANKS.get()), ModTags.Items.JACARANDA_LOG, (int)4);
        RecipeGenerator.planksFromLog(consumer, (ItemLike)((ItemLike)ModBlocks.MAGIC_PLANKS.get()), ModTags.Items.MAGIC_LOG, (int)4);
        RecipeGenerator.woodFromLogs(consumer, (ItemLike)((ItemLike)ModBlocks.JACARANDA_WOOD.get()), (ItemLike)((ItemLike)ModBlocks.JACARANDA_LOG.get()));
        RecipeGenerator.woodFromLogs(consumer, (ItemLike)((ItemLike)ModBlocks.MAGIC_WOOD.get()), (ItemLike)((ItemLike)ModBlocks.MAGIC_LOG.get()));
        RecipeGenerator.woodFromLogs(consumer, (ItemLike)((ItemLike)ModBlocks.STRIPPED_JACARANDA_WOOD.get()), (ItemLike)((ItemLike)ModBlocks.STRIPPED_JACARANDA_LOG.get()));
        RecipeGenerator.woodFromLogs(consumer, (ItemLike)((ItemLike)ModBlocks.STRIPPED_MAGIC_WOOD.get()), (ItemLike)((ItemLike)ModBlocks.STRIPPED_MAGIC_LOG.get()));
        RecipeGenerator.woodenBoat(consumer, (ItemLike)((ItemLike)ModItems.JACARANDA_BOAT.get()), (ItemLike)((ItemLike)ModBlocks.JACARANDA_PLANKS.get()));
        RecipeGenerator.woodenBoat(consumer, (ItemLike)((ItemLike)ModItems.MAGIC_BOAT.get()), (ItemLike)((ItemLike)ModBlocks.MAGIC_PLANKS.get()));
        RecipeGenerator.chestBoat(consumer, (ItemLike)((ItemLike)ModItems.JACARANDA_CHEST_BOAT.get()), (ItemLike)((ItemLike)ModBlocks.JACARANDA_PLANKS.get()));
        RecipeGenerator.chestBoat(consumer, (ItemLike)((ItemLike)ModItems.MAGIC_CHEST_BOAT.get()), (ItemLike)((ItemLike)ModBlocks.MAGIC_PLANKS.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.WOLFSBANE_DIFFUSER_LONG.get())).pattern("XYX").pattern("YZY").pattern("OOO").define(Character.valueOf('X'), planks).define(Character.valueOf('Y'), diamond).define(Character.valueOf('O'), obsidian).define(Character.valueOf('Z'), wolfsbane_diffuser_core).unlockedBy("has_diamond", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)diamond)).save(consumer, "wolfsbane_diffuser_normal");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.WOLFSBANE_DIFFUSER.get())).pattern("XYX").pattern("YZY").pattern("OOO").define(Character.valueOf('X'), planks).define(Character.valueOf('Y'), diamond).define(Character.valueOf('O'), obsidian).define(Character.valueOf('Z'), wolfsbane_diffuser_core_improved).unlockedBy("has_garlic_diffuser", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)wolfsbane_diffuser)).unlockedBy("has_diamond", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)diamond)).save(consumer, "wolfsbane_diffuser_improved");
        AlchemicalCauldronRecipeBuilder.cauldronRecipe((Item)((Item)ModItems.WOLFSBANE_DIFFUSER_CORE.get())).withIngredient(wool).withFluid(new ItemLike[]{wolfsbane}).withSkills(new ISkill[]{(ISkill)HunterSkills.GARLIC_DIFFUSER.get()}).build(consumer, RecipeGenerator.modId("wolfsbane_diffuser_core"));
        AlchemicalCauldronRecipeBuilder.cauldronRecipe((Item)((Item)ModItems.WOLFSBANE_DIFFUSER_CORE_IMPROVED.get())).withIngredient(new ItemLike[]{wolfsbane_diffuser_core}).withFluid(new ItemLike[]{wolfsbane}).withSkills(new ISkill[]{(ISkill)HunterSkills.GARLIC_DIFFUSER_IMPROVED.get()}).experience(2.0f).build(consumer, RecipeGenerator.modId("wolfsbane_diffuser_core_improved"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.PELT_HELMET.get())).define(Character.valueOf('P'), pelt).pattern("PPP").pattern("P P").unlockedBy("has_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)pelt)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.PELT_CHESTPLATE.get())).define(Character.valueOf('P'), pelt).pattern("P P").pattern("PPP").pattern("PPP").unlockedBy("has_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)pelt)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.PELT_LEGGINGS.get())).define(Character.valueOf('P'), pelt).pattern("PPP").pattern("P P").pattern("P P").unlockedBy("has_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)pelt)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.PELT_BOOTS.get())).define(Character.valueOf('P'), pelt).pattern("P P").pattern("P P").unlockedBy("has_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)pelt)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DARK_PELT_HELMET.get())).define(Character.valueOf('P'), dark_pelt).define(Character.valueOf('X'), (ItemLike)ModItems.PELT_HELMET.get()).pattern("PPP").pattern("PXP").pattern("PPP").unlockedBy("has_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)dark_pelt)).unlockedBy("has_pelt_helmet", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.PELT_HELMET.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DARK_PELT_CHESTPLATE.get())).define(Character.valueOf('P'), dark_pelt).define(Character.valueOf('X'), (ItemLike)ModItems.PELT_CHESTPLATE.get()).pattern("PPP").pattern("PXP").pattern("PPP").unlockedBy("has_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)dark_pelt)).unlockedBy("has_pelt_chestplate", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.PELT_CHESTPLATE.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DARK_PELT_LEGGINGS.get())).define(Character.valueOf('P'), dark_pelt).define(Character.valueOf('X'), (ItemLike)ModItems.PELT_LEGGINGS.get()).pattern("PPP").pattern("PXP").pattern("PPP").unlockedBy("has_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)dark_pelt)).unlockedBy("has_pelt_leggings", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.PELT_LEGGINGS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DARK_PELT_BOOTS.get())).define(Character.valueOf('P'), dark_pelt).define(Character.valueOf('X'), (ItemLike)ModItems.PELT_BOOTS.get()).pattern("PPP").pattern("PXP").pattern("PPP").unlockedBy("has_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)dark_pelt)).unlockedBy("has_pelt_boots", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.PELT_BOOTS.get()))).save(consumer);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DARK_PELT_HELMET.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)ModItems.WHITE_PELT_HELMET.get())).unlocks("has_white_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.WHITE_PELT.get()))).save(consumer, RecipeGenerator.getItemName((ItemLike)((ItemLike)ModItems.WHITE_PELT_HELMET.get())) + "_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DARK_PELT_CHESTPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)ModItems.WHITE_PELT_CHESTPLATE.get())).unlocks("has_white_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.WHITE_PELT.get()))).save(consumer, RecipeGenerator.getItemName((ItemLike)((ItemLike)ModItems.WHITE_PELT_CHESTPLATE.get())) + "_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DARK_PELT_LEGGINGS.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)ModItems.WHITE_PELT_LEGGINGS.get())).unlocks("has_white_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.WHITE_PELT.get()))).save(consumer, RecipeGenerator.getItemName((ItemLike)((ItemLike)ModItems.WHITE_PELT_LEGGINGS.get())) + "_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DARK_PELT_BOOTS.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WHITE_PELT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)ModItems.WHITE_PELT_BOOTS.get())).unlocks("has_white_pelt", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)((ItemLike)ModItems.WHITE_PELT.get()))).save(consumer, RecipeGenerator.getItemName((ItemLike)((ItemLike)ModItems.WHITE_PELT_BOOTS.get())) + "_smithing");
        RecipeGenerator.copySmithingTemplate(consumer, (ItemLike)((ItemLike)ModItems.WHITE_PELT_UPGRADE_SMITHING_TEMPLATE.get()), (ItemLike)((ItemLike)ModItems.WEREWOLF_TOOTH.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.WOLFSBANE_FINDER.get())).pattern("XXX").pattern("XYX").pattern("ZAZ").define(Character.valueOf('X'), silver_ingot).define(Character.valueOf('Y'), wolfsbane).define(Character.valueOf('Z'), planks).define(Character.valueOf('A'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_redstone", (CriterionTriggerInstance)RecipeGenerator.has((TagKey)Tags.Items.DUSTS_REDSTONE)).unlockedBy("has_silver_ingot", (CriterionTriggerInstance)RecipeGenerator.has(silver_ingot)).save(consumer);
    }
}

