/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WerewolfBeastModel<T extends LivingEntity>
extends WerewolfBaseModel<T> {
    public static final String BODY = "body";
    public static final String HIP = "hip";
    public static final String NECK = "neck";
    public static final String ARM_LEFT = "armLeft";
    public static final String ARM_RIGHT = "armRight";
    public static final String BODY_FLUFF = "bodyFluff";
    public static final String LEG_LEFT = "legLeft";
    public static final String LEG_RIGHT = "legRight";
    public static final String TAIL = "tail";
    public static final String LEG_LEFT_2 = "legLeft2";
    public static final String FOOT_LEFT = "footLeft";
    public static final String LEG_RIGHT_2 = "legRight2";
    public static final String FOOT_RIGHT = "footRight";
    public static final String TAIL_2 = "tail2";
    public static final String TAIL_3 = "tail3";
    public static final String JOINT = "joint";
    public static final String NECK_FLUFF = "neckFluff";
    public static final String NECK_FLUFF_LEFT = "neckFluffLeft";
    public static final String NECK_FLUFF_RIGHT = "neckFluffRight";
    public static final String NECK_FLUFF_BOTTOM = "neckFluffBottom";
    public static final String HEAD = "head";
    public static final String EAR_LEFT = "earLeft";
    public static final String EAR_RIGHT = "earRight";
    public static final String SNOUT = "snout";
    public static final String JAW = "jaw";
    public static final String HEAD_FLUFF = "headFluff";
    public static final String HEAD_SIDBURN_LEFT = "headSidburnLeft";
    public static final String HEAD_SIDBURN_RIGHT = "headSidburnRight";
    public static final String EAR_LEFT_2 = "earLeft2";
    public static final String EAR_RIGHT_2 = "earRight2";
    public static final String NOSE = "nose";
    public static final String SNOUT_TEETH = "snoutTeeth";
    public static final String JAW_TEETH = "jawTeeth";
    public static final String JAW_FLUFF = "jawFluff";
    public static final String ARM_LEFT_2 = "armLeft2";
    public static final String FINGER_LEFT = "fingerLeft";
    public static final String FINGER_LEFT_2 = "fingerLeft2";
    public static final String FINGER_LEFT_3 = "fingerLeft3";
    public static final String FINGER_LEFT_4 = "fingerLeft4";
    public static final String THUMB_LEFT = "thumbLeft";
    public static final String ARM_RIGHT_2 = "armRight2";
    public static final String FINGER_RIGHT = "fingerRight";
    public static final String FINGER_RIGHT_2 = "fingerRight2";
    public static final String FINGER_RIGHT_3 = "fingerRight3";
    public static final String FINGER_RIGHT_4 = "fingerRight4";
    public static final String THUMB_RIGHT = "thumbRight";
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart armRight2;
    public final ModelPart armLeft2;
    public final ModelPart legLeft;
    public final ModelPart legRight;
    public final ModelPart hip;
    public final ModelPart tail;
    public final ModelPart jaw;
    public final ModelPart earLeft;
    public final ModelPart earRight;
    public final ModelPart joint;
    public final ModelPart neck;
    private final List<ModelPart> parts;

    public WerewolfBeastModel(ModelPart part) {
        super(part);
        this.body = part.getChild(BODY);
        this.hip = this.body.getChild(HIP);
        this.rightArm = this.body.getChild(ARM_RIGHT);
        this.leftArm = this.body.getChild(ARM_LEFT);
        this.legRight = this.hip.getChild(LEG_RIGHT);
        this.legLeft = this.hip.getChild(LEG_LEFT);
        this.armLeft2 = this.leftArm.getChild(ARM_LEFT_2);
        this.armRight2 = this.rightArm.getChild(ARM_RIGHT_2);
        this.tail = this.hip.getChild(TAIL);
        this.neck = this.body.getChild(NECK);
        this.joint = this.neck.getChild(JOINT);
        this.head = this.joint.getChild(HEAD);
        this.jaw = this.head.getChild(JAW);
        this.earLeft = this.head.getChild(EAR_LEFT);
        this.earRight = this.head.getChild(EAR_RIGHT);
        this.parts = part.getAllParts().filter(s -> !s.isEmpty()).toList();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = WerewolfBaseModel.createMesh(CubeDeformation.NONE);
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild(BODY, CubeListBuilder.create().texOffs(0, 13).addBox(-4.5f, 0.0f, -4.0f, 9.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild(NECK, CubeListBuilder.create().texOffs(0, 45).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 7.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)1.0f, (float)0.6981317f, (float)0.0f, (float)0.0f));
        PartDefinition joint = neck.addOrReplaceChild(JOINT, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)-1.0f, (float)-1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition head = joint.addOrReplaceChild(HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition snout = head.addOrReplaceChild(SNOUT, CubeListBuilder.create().texOffs(34, 0).addBox(-2.0f, -2.0f, -4.0f, 4.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-5.0f, (float)-0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition hip = body.addOrReplaceChild(HIP, CubeListBuilder.create().texOffs(0, 30).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 9.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)1.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition headSidburnLeft = head.addOrReplaceChild(HEAD_SIDBURN_LEFT, CubeListBuilder.create().texOffs(32, 12).addBox(1.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f), PartPose.rotation((float)0.0f, (float)-0.5235988f, (float)0.0f));
        PartDefinition legRight = hip.addOrReplaceChild(LEG_RIGHT, CubeListBuilder.create().texOffs(24, 39).addBox(0.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)9.0f, (float)0.0f, (float)-0.3826f, (float)-0.0327f, (float)-0.0809f));
        PartDefinition jaw = head.addOrReplaceChild(JAW, CubeListBuilder.create().texOffs(50, 0).addBox(-1.5f, 0.0f, -3.5f, 3.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)-5.0f, (float)0.0939f, (float)0.0f, (float)0.0f));
        PartDefinition jawFluff = jaw.addOrReplaceChild(JAW_FLUFF, CubeListBuilder.create().texOffs(96, 8).addBox(-1.5f, 2.0f, -3.5f, 3.0f, 2.0f, 4.0f), PartPose.ZERO);
        PartDefinition neckFluff = neck.addOrReplaceChild(NECK_FLUFF, CubeListBuilder.create().texOffs(64, 19).addBox(-3.5f, -5.0f, 2.5f, 7.0f, 8.0f, 2.0f), PartPose.rotation((float)0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition tail = hip.addOrReplaceChild(TAIL, CubeListBuilder.create().texOffs(62, 30).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)2.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition earLeft = head.addOrReplaceChild(EAR_LEFT, CubeListBuilder.create().texOffs(26, 0).addBox(3.5f, -2.5f, -2.5f, 1.0f, 4.0f, 3.0f), PartPose.rotation((float)-0.4886922f, (float)0.34906584f, (float)0.0f));
        PartDefinition legRight2 = legRight.addOrReplaceChild(LEG_RIGHT_2, CubeListBuilder.create().texOffs(44, 44).addBox(0.5f, 2.0f, 3.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition footRight = legRight2.addOrReplaceChild(FOOT_RIGHT, CubeListBuilder.create().texOffs(24, 54).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)12.0f, (float)5.0f, (float)0.384f, (float)0.0f, (float)0.0f));
        PartDefinition snoutTeeth = snout.addOrReplaceChild(SNOUT_TEETH, CubeListBuilder.create().texOffs(34, 6).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 2.0f, 4.0f), PartPose.ZERO);
        PartDefinition headSidburnRight = head.addOrReplaceChild(HEAD_SIDBURN_RIGHT, CubeListBuilder.create().texOffs(32, 12).addBox(-4.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f).mirror(), PartPose.rotation((float)0.0f, (float)0.5235988f, (float)0.0f));
        PartDefinition nose = snout.addOrReplaceChild(NOSE, CubeListBuilder.create().texOffs(64, 0).addBox(-1.5f, -3.5f, -3.7f, 3.0f, 2.0f, 5.0f), PartPose.rotation((float)0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition bodyFluff = body.addOrReplaceChild(BODY_FLUFF, CubeListBuilder.create().texOffs(82, 14).addBox(-4.5f, 8.0f, -4.0f, 9.0f, 3.0f, 8.0f), PartPose.ZERO);
        PartDefinition tail2 = tail.addOrReplaceChild(TAIL_2, CubeListBuilder.create().texOffs(62, 37).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild(TAIL_3, CubeListBuilder.create().texOffs(62, 49).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.8f, (float)0.0f, (float)0.13665928f, (float)0.0f, (float)0.0f));
        PartDefinition neckFluffRight = neck.addOrReplaceChild(NECK_FLUFF_RIGHT, CubeListBuilder.create().texOffs(82, 25).addBox(-3.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f), PartPose.rotation((float)0.34906584f, (float)-1.5707964f, (float)0.0f));
        PartDefinition headFluff = head.addOrReplaceChild(HEAD_FLUFF, CubeListBuilder.create().texOffs(96, 0).addBox(-3.5f, 3.5f, -5.0f, 7.0f, 2.0f, 6.0f), PartPose.ZERO);
        PartDefinition legLeft = hip.addOrReplaceChild(LEG_LEFT, CubeListBuilder.create().texOffs(24, 39).addBox(-4.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)9.0f, (float)0.0f, (float)-0.3826f, (float)0.0327f, (float)0.0809f));
        PartDefinition earRight = head.addOrReplaceChild(EAR_RIGHT, CubeListBuilder.create().texOffs(26, 0).addBox(-4.5f, -2.5f, -2.5f, 1.0f, 4.0f, 3.0f), PartPose.rotation((float)-0.4886922f, (float)-0.34906584f, (float)0.0f));
        PartDefinition earRight2 = earRight.addOrReplaceChild(EAR_RIGHT_2, CubeListBuilder.create().texOffs(26, 7).addBox(-4.0f, -5.5f, -2.0f, 1.0f, 4.0f, 2.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)-0.17453292f));
        PartDefinition legLeft2 = legLeft.addOrReplaceChild(LEG_LEFT_2, CubeListBuilder.create().texOffs(44, 44).mirror().addBox(-3.5f, 2.0f, 3.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition footLeft = legLeft2.addOrReplaceChild(FOOT_LEFT, CubeListBuilder.create().texOffs(24, 54).mirror().addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)5.0f, (float)0.384f, (float)0.0f, (float)0.0f));
        PartDefinition jawTeeth = jaw.addOrReplaceChild(JAW_TEETH, CubeListBuilder.create().texOffs(50, 6).addBox(-1.5f, -1.0f, -3.5f, 3.0f, 1.0f, 4.0f), PartPose.ZERO);
        PartDefinition neckFluffBottom = neck.addOrReplaceChild(NECK_FLUFF_BOTTOM, CubeListBuilder.create().texOffs(80, 0).addBox(-3.0f, -0.6f, 4.5f, 6.0f, 6.0f, 2.0f), PartPose.rotation((float)1.0471976f, (float)((float)Math.PI), (float)0.0f));
        PartDefinition earLeft2 = earLeft.addOrReplaceChild(EAR_LEFT_2, CubeListBuilder.create().texOffs(26, 7).addBox(3.0f, -5.5f, -2.0f, 1.0f, 4.0f, 2.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.17453292f));
        PartDefinition neckFluffLeft = neck.addOrReplaceChild(NECK_FLUFF_LEFT, CubeListBuilder.create().texOffs(82, 25).addBox(-2.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f), PartPose.rotation((float)0.34906584f, (float)1.5707964f, (float)0.0f));
        PartDefinition armRight = body.addOrReplaceChild(ARM_RIGHT, CubeListBuilder.create().texOffs(36, 25).addBox(0.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)3.0f, (float)0.0f, (float)-0.377f, (float)-0.0517f, (float)-0.3349f));
        PartDefinition armRight2 = armRight.addOrReplaceChild(ARM_RIGHT_2, CubeListBuilder.create().texOffs(48, 15).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 10.0f, 4.0f), PartPose.offsetAndRotation((float)2.0f, (float)7.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition thumbRight = armRight2.addOrReplaceChild(THUMB_RIGHT, CubeListBuilder.create().texOffs(0, 17).addBox(-0.5f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerRight = armRight2.addOrReplaceChild(FINGER_RIGHT, CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerRight2 = armRight2.addOrReplaceChild(FINGER_RIGHT_2, CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerRight3 = armRight2.addOrReplaceChild(FINGER_RIGHT_3, CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerRight4 = armRight2.addOrReplaceChild(FINGER_RIGHT_4, CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)1.5f, (float)0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition armLeft = body.addOrReplaceChild(ARM_LEFT, CubeListBuilder.create().texOffs(36, 25).mirror().addBox(-4.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.5f, (float)3.0f, (float)0.0f, (float)-0.377f, (float)0.0517f, (float)0.3349f));
        PartDefinition armLeft2 = armLeft.addOrReplaceChild(ARM_LEFT_2, CubeListBuilder.create().texOffs(48, 15).mirror().addBox(-1.5f, 0.0f, -2.0f, 3.0f, 10.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)7.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition thumbLeft = armLeft2.addOrReplaceChild(THUMB_LEFT, CubeListBuilder.create().texOffs(0, 17).mirror().addBox(-1.5f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f).mirror(false), PartPose.offsetAndRotation((float)1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerLeft = armLeft2.addOrReplaceChild(FINGER_LEFT, CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f).mirror(false), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerLeft2 = armLeft2.addOrReplaceChild(FINGER_LEFT_2, CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f).mirror(false), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerLeft3 = armLeft2.addOrReplaceChild(FINGER_LEFT_3, CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f).mirror(false), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerLeft4 = armLeft2.addOrReplaceChild(FINGER_LEFT_4, CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f).mirror(false), PartPose.offsetAndRotation((float)-1.2f, (float)9.0f, (float)1.5f, (float)0.2618f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    @Override
    @Nullable
    public ModelPart getModelRenderer() {
        return this.body;
    }

    @Override
    @Nullable
    public ModelPart getHeadModel() {
        return this.head;
    }

    @Override
    @Nullable
    public ModelPart getLeftArmModel() {
        return this.armRight2;
    }

    @Override
    @Nullable
    public ModelPart getRightArmModel() {
        return this.armLeft2;
    }

    @Override
    @Nonnull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void renderToBuffer(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void setupAnim(@Nonnull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.parts.forEach(ModelPart::resetPose);
        this.crouching = entityIn.isCrouching();
        boolean flag1 = entityIn.isVisuallySwimming();
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = this.swimAmount > 0.0f ? (flag1 ? this.rotlerpRad(this.head.xRot, -0.7853982f, this.swimAmount) : this.rotlerpRad(this.head.xRot, headPitch * ((float)Math.PI / 180), this.swimAmount)) : headPitch * ((float)Math.PI / 180);
        this.armLeft2.xRot = -1.0f;
        this.armRight2.xRot = -1.0f;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount * 0.5f;
        this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightArm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftArm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.legRight.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f)) * 1.4f * limbSwingAmount;
        this.legLeft.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (this.crouching) {
            this.body.xRot = 0.7235988f;
            this.hip.xRot = -0.7235988f;
        } else {
            this.body.xRot = 0.5235988f;
            this.hip.xRot = -0.5235988f;
        }
        this.tail.xRot = 0.7853982f;
        this.tail.xRot -= 0.035f;
        this.tail.xRot += Mth.cos((float)(ageInTicks * 0.1f)) * 0.07f;
        this.tail.yRot = -0.035f;
        this.tail.yRot += Mth.sin((float)(ageInTicks * 0.14f)) * 0.07f;
        this.tail.xRot += Mth.cos((float)(limbSwing * 0.6662f * 0.7f)) * 0.3f * Mth.abs((float)limbSwingAmount) + 0.3f;
        this.tail.yRot += Mth.sin((float)(limbSwing * 0.6662f * 0.7f)) * 0.1f * limbSwingAmount;
        this.jaw.xRot += Mth.cos((float)(ageInTicks * 0.04f)) * 0.05f;
        if (this.attackTime > 0.0f) {
            HumanoidArm humanoidarm = this.getAttackArm(entityIn);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.neck.yRot = Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.neck.yRot *= -1.0f;
            }
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin((float)(f * (float)Math.PI));
            float f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.body.yRot * 2.0f;
            f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * 0.75f;
            this.jaw.xRot += f1 * 1.4f - f2;
            float zChange = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
            modelpart.zRot = humanoidarm == HumanoidArm.LEFT ? (modelpart.zRot -= zChange) : (modelpart.zRot += zChange);
        }
        this.earLeft.xRot = -0.4886922f;
        this.earLeft.xRot += Mth.cos((float)(ageInTicks * 0.1f)) * 0.07f;
        this.earRight.xRot = -0.4886922f;
        this.earRight.xRot += Mth.cos((float)(ageInTicks * 0.1f)) * 0.07f;
    }

    @Override
    public void translateToHand(@NotNull HumanoidArm arm, @NotNull PoseStack stack) {
        this.body.translateAndRotate(stack);
        ModelPart mainArm = arm == HumanoidArm.RIGHT ? this.leftArm : this.rightArm;
        mainArm.translateAndRotate(stack);
        ModelPart lowerArm = arm == HumanoidArm.RIGHT ? this.armLeft2 : this.armRight2;
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        lowerArm.x += f;
        lowerArm.translateAndRotate(stack);
        lowerArm.x -= f;
    }

    public void translateToHead(PoseStack stack) {
        this.body.translateAndRotate(stack);
        this.neck.translateAndRotate(stack);
        this.joint.translateAndRotate(stack);
        this.head.translateAndRotate(stack);
    }

    @Nonnull
    public static List<ResourceLocation> getBeastTextures() {
        List<ResourceLocation> locs = WerewolfBeastModel.getTextures("textures/entity/werewolf/beast");
        if (locs.size() < WerewolfForm.BEAST.getSkinTypes()) {
            for (int i = locs.size(); i < WerewolfForm.BEAST.getSkinTypes(); ++i) {
                ResourceLocation s = new ResourceLocation("werewolves", "textures/entity/werewolf/beast/beast_" + i + ".png");
                locs.add(s);
            }
        }
        return locs;
    }

    @Override
    @NotNull
    protected ModelPart getArm(@NotNull HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.rightArm : this.leftArm;
    }

    public ModelPart getRandomModelPart(RandomSource pRandom) {
        return this.parts.get(pRandom.nextInt(this.parts.size()));
    }
}

