/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolfAlpha;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class WerewolfAlphaEntity
extends WerewolfBaseEntity
implements IWerewolfAlpha {
    public static final int MAX_LEVEL = 4;
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.defineId(WerewolfAlphaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int followingEntities = 0;

    public static boolean spawnPredicateAlpha(EntityType<? extends WerewolfAlphaEntity> entityType, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return world.getBiome(blockPos).is(ModBiomes.WEREWOLF_FOREST) && world.getDifficulty() != net.minecraft.world.Difficulty.PEACEFUL && WerewolfAlphaEntity.spawnPredicateWerewolf(entityType, world, spawnReason, blockPos, random);
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampireBaseEntity.getAttributeBuilder();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder2 = builder.add(Attributes.MAX_HEALTH, 140.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder3 = builder2.add(Attributes.ATTACK_DAMAGE, 6.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder3.add(Attributes.MOVEMENT_SPEED, 0.34).add(Attributes.FOLLOW_RANGE, 5.0);
    }

    public WerewolfAlphaEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, true);
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("level", this.getEntityLevel());
    }

    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    public int getFollowingCount() {
        return this.followingEntities;
    }

    public void setEntityLevel(int level) {
        if ((level = Mth.clamp((int)level, (int)0, (int)4)) >= 0) {
            this.getEntityData().set(LEVEL, (Object)level);
            this.updateEntityAttributes();
            this.setCustomName((Component)this.getTypeName().plainCopy().append((Component)Component.translatable((String)"entity.werewolves.alpha_werewolf.level", (Object[])new Object[]{level + 1})));
        } else {
            this.setCustomName(null);
        }
    }

    public int getEntityLevel() {
        return (Integer)this.getEntityData().get(LEVEL);
    }

    public int getMaxEntityLevel() {
        return 4;
    }

    public int getMaxHeadXRot() {
        return 5;
    }

    public int getMaxHeadYRot() {
        return 5;
    }

    public int getMaxFollowerCount() {
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return (int)(5.0f * ((float)(this.getEntityLevel() + 1) / (float)(this.getMaxEntityLevel() + 1)));
    }

    protected boolean canRide(@NotNull Entity pVehicle) {
        return false;
    }

    public int getPortalWaitTime() {
        return 500;
    }

    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        super.killedEntity(level, entity);
        if (entity instanceof WerewolfAlphaEntity) {
            this.setHealth(this.getMaxHealth());
        }
        return true;
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setEntityLevel(nbt.getInt("level"));
    }

    public boolean shouldShowName() {
        return true;
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ENTITY_WEREWOLF_GROWL.get();
    }

    public int suggestEntityLevel(Difficulty d) {
        int avg = Math.round(((float)d.avgPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int max = Math.round(((float)d.maxPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int min = Math.round(((float)d.minPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        return switch (this.random.nextInt(7)) {
            case 0 -> min;
            case 1 -> max + 1;
            case 2 -> avg;
            case 3 -> avg + 1;
            case 4, 5 -> this.random.nextInt(5);
            default -> this.random.nextInt(max + 2 - min) + min;
        };
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.getEntityData().define(LEVEL, (Object)-1);
    }

    public int getExperienceReward() {
        return 20 + 5 * this.getEntityLevel();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 0.6, (double)0.7f, input -> input != null && !this.isLowerLevel((LivingEntity)input)));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.2));
        this.goalSelector.addGoal(9, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::isLowerLevel));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, WerewolfAlphaEntity.class, true, false));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    private boolean isLowerLevel(LivingEntity player) {
        if (player instanceof Player) {
            int playerLevel = FactionPlayerHandler.getOpt((Player)((Player)player)).map(FactionPlayerHandler::getCurrentLevel).orElse(0);
            return (float)(playerLevel - 8) / 2.0f - (float)this.getEntityLevel() <= 0.0f;
        }
        return false;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return WerewolfForm.BEAST4L;
    }

    @Override
    public int getSkinType(@Nullable WerewolfForm form) {
        return this.getId();
    }

    @Override
    public int getEyeType(@Nullable WerewolfForm form) {
        return 0;
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return true;
    }

    protected void updateEntityAttributes() {
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(20.0);
        AttributeInstance attributeInstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.setBaseValue(0.34 * Math.pow((1.2 - 1.0) / 5.0 + 1.0, this.getEntityLevel()));
        AttributeInstance attributeInstance2 = this.getAttribute(Attributes.MAX_HEALTH);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance2.setBaseValue(140.0 * Math.pow(1.2, this.getEntityLevel()));
        AttributeInstance attributeInstance3 = this.getAttribute(Attributes.ATTACK_DAMAGE);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance3.setBaseValue(6.0 * Math.pow(1.2, this.getEntityLevel()));
    }
}

