/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class HumanWerewolfEntity
extends PathfinderMob
implements WerewolfTransformable {
    private static final EntityDataAccessor<Integer> FORM = SynchedEntityData.defineId(HumanWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SKIN_TYPE = SynchedEntityData.defineId(HumanWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> EYE_TYPE = SynchedEntityData.defineId(HumanWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> GLOWING_EYES = SynchedEntityData.defineId(HumanWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final EntityClassType classType = EntityClassType.getRandomClass((RandomSource)this.getRandom());
    private final EntityActionTier actionTier = EntityActionTier.Medium;
    protected int rage;

    public HumanWerewolfEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean spawnPredicateHumanWerewolf(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        if (world.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if (spawnReason == MobSpawnType.EVENT) {
            return true;
        }
        if (!Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)blockPos, (RandomSource)random) && !FormHelper.isInWerewolfBiome((LevelAccessor)world, blockPos)) {
            return false;
        }
        return Mob.checkMobSpawnRules(entityType, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)random);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.getEntityData().define(FORM, (Object)-1);
        this.getEntityData().define(SKIN_TYPE, (Object)-1);
        this.getEntityData().define(EYE_TYPE, (Object)-1);
        this.getEntityData().define(GLOWING_EYES, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean hurt(@Nonnull DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            this.rage = (int)((float)this.rage + amount * 10.0f);
            return true;
        }
        return false;
    }

    public void aiStep() {
        super.aiStep();
        if (this.rage > 150) {
            WerewolfTransformable werewolf = this.transformToWerewolf(TransformType.TIME_LIMITED);
            ((Mob)werewolf).setLastHurtByMob(this.getTarget());
        }
        if (this.level().getGameTime() % 400L == 10L) {
            if (Helper.isFullMoon(this.level())) {
                this.transformToWerewolf(TransformType.FULL_MOON);
            }
            this.rage -= 2;
        }
    }

    @Override
    public void reset() {
        this.rage = 0;
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return PathfinderMob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.36).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MAX_HEALTH, 30.0);
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        int t;
        super.readAdditionalSaveData(compound);
        if (compound.contains("form")) {
            t = compound.getInt("form");
            this.getEntityData().set(FORM, (Object)(t < 2 && t >= 0 ? t : -1));
        }
        if (compound.contains("type")) {
            t = compound.getInt("type");
            this.getEntityData().set(SKIN_TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (compound.contains("eye_type")) {
            t = compound.getInt("eye_type");
            this.getEntityData().set(EYE_TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (compound.contains("glowing_eye")) {
            this.getEntityData().set(GLOWING_EYES, (Object)compound.getBoolean("glowing_eye"));
        }
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("form", ((Integer)this.getEntityData().get(FORM)).intValue());
        compound.putInt("type", ((Integer)this.getEntityData().get(SKIN_TYPE)).intValue());
        compound.putInt("eye_type", ((Integer)this.getEntityData().get(EYE_TYPE)).intValue());
        compound.putBoolean("glowing_eye", ((Boolean)this.getEntityData().get(GLOWING_EYES)).booleanValue());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.getEntityData().get(FORM) == -1) {
            this.getEntityData().set(FORM, (Object)this.getRandom().nextInt(2));
        }
        if ((Integer)this.getEntityData().get(SKIN_TYPE) == -1) {
            this.getEntityData().set(SKIN_TYPE, (Object)this.getRandom().nextInt(126));
        }
        if ((Integer)this.getEntityData().get(EYE_TYPE) == -1) {
            this.getEntityData().set(EYE_TYPE, (Object)this.getRandom().nextInt(126));
        }
        this.getEntityData().set(GLOWING_EYES, (Object)this.getRandom().nextBoolean());
    }

    @Override
    public int getSkinType(@Nullable WerewolfForm form) {
        int i = (Integer)this.getEntityData().get(SKIN_TYPE);
        return Math.max(i, 0);
    }

    @Override
    public int getEyeType(@Nullable WerewolfForm form) {
        int i = (Integer)this.getEntityData().get(EYE_TYPE);
        return Math.max(i, 0);
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return (Boolean)this.getEntityData().get(GLOWING_EYES);
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        EntityType type = (Integer)this.getEntityData().get(FORM) == 0 ? (EntityType)ModEntities.WEREWOLF_BEAST.get() : (EntityType)ModEntities.WEREWOLF_SURVIVALIST.get();
        BasicWerewolfEntity werewolf = (BasicWerewolfEntity)WerewolfTransformable.copyData(type, (Mob)this);
        werewolf.setSourceEntity(this);
        return werewolf;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.actionTier;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.classType;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        return this;
    }

    @Override
    public boolean canTransform() {
        return !this.level().isClientSide && Helper.isNight(this.level()) && this.rage > 0;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return switch ((Integer)this.getEntityData().get(FORM)) {
            case 0 -> WerewolfForm.BEAST;
            case 1 -> WerewolfForm.SURVIVALIST;
            default -> WerewolfForm.HUMAN;
        };
    }
}

