/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.werewolves.api.entities.IEntityFollower;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.entities.goals.DefendLeaderGoal;
import de.teamlapen.werewolves.entities.goals.FollowAlphaWerewolfGoal;
import de.teamlapen.werewolves.entities.goals.WerewolfAttackVillageGoal;
import de.teamlapen.werewolves.entities.goals.WerewolfDefendVillageGoal;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WerewolfVillageData;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class BasicWerewolfEntity
extends WerewolfBaseEntity
implements WerewolfTransformable,
IVillageCaptureEntity,
IEntityFollower,
IAdjustableLevel,
IFactionEntity {
    protected static final EntityDataAccessor<Integer> SKINTYPE = SynchedEntityData.defineId(BasicWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> EYETYPE = SynchedEntityData.defineId(BasicWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.defineId(BasicWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MAX_LEVEL = 2;
    private static final Logger LOGGER = LogManager.getLogger();
    private WerewolfTransformable transformed;
    private int transformedDuration;
    private TransformType transformType;
    private EntityClassType entityClass;
    private EntityActionTier entityTier;
    private IEntityLeader entityLeader;
    @Nullable
    protected ICaptureAttributes villageAttributes;
    protected boolean attack;

    public BasicWerewolfEntity(EntityType<? extends BasicWerewolfEntity> type, Level world) {
        super(type, world, true);
        this.entityClass = EntityClassType.getRandomClass((RandomSource)world.random);
        this.entityTier = EntityActionTier.Low;
        this.xpReward = 3;
    }

    @Nonnull
    public EntityDimensions getDimensions(@Nonnull Pose poseIn) {
        return this.getForm().getSize(poseIn).map(p -> p.scale(this.getScale())).orElse(super.getDimensions(poseIn));
    }

    public boolean isPersistenceRequired() {
        return super.isPersistenceRequired() || this.transformed != null;
    }

    @Override
    @Nonnull
    public abstract WerewolfForm getForm();

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        return this;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        if (this.transformed == null) {
            return this;
        }
        ((Mob)this.transformed).copyPosition((Entity)this);
        ((Mob)this.transformed).revive();
        this.level().addFreshEntity((Entity)((Mob)this.transformed));
        this.remove(Entity.RemovalReason.DISCARDED);
        ((Mob)this.transformed).setHealth(this.getHealth() / this.getMaxHealth() * ((Mob)this.transformed).getMaxHealth());
        return this.transformed;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entityTier;
    }

    @Override
    public int getSkinType(@Nullable WerewolfForm form) {
        return Math.max(0, (Integer)this.getEntityData().get(SKINTYPE));
    }

    @Override
    public int getEyeType(@Nullable WerewolfForm form) {
        return Math.max(0, (Integer)this.getEntityData().get(EYETYPE));
    }

    @Override
    public void start(TransformType type) {
        this.transformType = type;
        if (type == TransformType.TIME_LIMITED) {
            this.transformedDuration = (Integer)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_transform_duration.get();
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.transformed != null && this.level().getGameTime() % 20L == 0L) {
            switch (this.transformType) {
                case TIME_LIMITED: {
                    if (--this.transformedDuration > 0) break;
                    this.transformBack();
                    break;
                }
                case FULL_MOON: {
                    if (Helper.isFullMoon(this.level())) break;
                    this.transformBack();
                }
            }
        }
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag nbt) {
        Entity entity;
        ResourceLocation id;
        EntityType type;
        int t;
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("level")) {
            this.setEntityLevel(nbt.getInt("level"));
        }
        if (nbt.contains("type")) {
            t = nbt.getInt("type");
            this.getEntityData().set(SKINTYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.contains("eyeType")) {
            t = nbt.getInt("eyeType");
            this.getEntityData().set(EYETYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.contains("transformedDuration")) {
            this.transformedDuration = nbt.getInt("transformedDuration");
        }
        if (nbt.contains("attack")) {
            this.attack = nbt.getBoolean("attack");
        }
        if (nbt.contains("transformType")) {
            this.transformType = TransformType.valueOf(nbt.getString("transformType"));
        }
        if (nbt.contains("transformed") && (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id = new ResourceLocation(nbt.getString("transformed_id")))) != null && (entity = type.create(this.level())) instanceof LivingEntity && entity instanceof WerewolfTransformable) {
            ((LivingEntity)entity).readAdditionalSaveData(nbt.getCompound("transformed"));
            this.transformed = (WerewolfTransformable)entity;
        }
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("transformedDuration", this.transformedDuration);
        if (this.transformType != null) {
            nbt.putString("transformType", this.transformType.name());
        }
        nbt.putInt("level", this.getEntityLevel());
        nbt.putInt("type", this.getSkinType());
        nbt.putInt("eyeType", this.getEyeType());
        nbt.putBoolean("attack", this.attack);
        if (this.transformed != null) {
            CompoundTag transformed = new CompoundTag();
            ((LivingEntity)this.transformed).saveWithoutId(transformed);
            nbt.put("transformed", (Tag)transformed);
            nbt.putString("transformed_id", RegUtil.id((EntityType)((LivingEntity)this.transformed).getType()).toString());
        }
    }

    public boolean hurt(@Nonnull DamageSource source, float amount) {
        if (this.transformType == TransformType.TIME_LIMITED) {
            this.transformedDuration = (Integer)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_transform_duration.get() * 20;
        }
        return super.hurt(source, amount);
    }

    public int getEntityLevel() {
        return (Integer)this.getEntityData().get(LEVEL);
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return true;
    }

    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.getEntityData().set(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1000000, 1, false, false));
            }
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    @Nonnull
    protected InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        int werewolfLevel = WerewolfPlayer.getOpt(player).map(FactionBasePlayer::getLevel).orElse(0);
        if (werewolfLevel > 0) {
            FactionPlayerHandler.getOpt((Player)player).ifPresent(fph -> {
                if (fph.getMaxMinions() > 0) {
                    ItemStack heldItem = player.getItemInHand(hand);
                    if (this.getEntityLevel() > 0) {
                        if (heldItem.getItem() == ModItems.WEREWOLF_MINION_CHARM.get()) {
                            player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.basic_werewolf.minion.unavailable"), true);
                        }
                    } else {
                        boolean freeSlot = MinionWorldData.getData((Level)player.level()).map(data -> data.getOrCreateController(fph)).map(PlayerMinionController::hasFreeMinionSlot).orElse(false);
                        player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.basic_werewolf.minion.available"), false);
                        if (heldItem.getItem() == ModItems.WEREWOLF_MINION_CHARM.get()) {
                            if (!freeSlot) {
                                player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.basic_werewolf.minion.no_free_slot"), false);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.basic_werewolf.minion.start_serving"), false);
                                this.convertToMinion(player);
                                if (!player.getAbilities().instabuild) {
                                    heldItem.shrink(1);
                                }
                            }
                        } else if (freeSlot) {
                            player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.basic_werewolf.minion.require_equipment", (Object[])new Object[]{UtilLib.translate((String)((Item)ModItems.WEREWOLF_MINION_CHARM.get()).getDescriptionId(), (Object[])new Object[0])}), false);
                        }
                    }
                }
            });
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void convertToMinion(Player lord) {
        FactionPlayerHandler.getOpt((Player)lord).ifPresent(fph -> {
            if (fph.getMaxMinions() > 0) {
                MinionWorldData.getData((Level)lord.level()).map(w -> w.getOrCreateController(fph)).ifPresent(controller -> {
                    if (controller.hasFreeMinionSlot()) {
                        if (fph.getCurrentFaction() == this.getFaction()) {
                            boolean hasIncreasedStats = fph.getCurrentFactionPlayer().map(IFactionPlayer::getSkillHandler).map(skillHandler -> skillHandler.isSkillEnabled((ISkill)ModSkills.MINION_STATS_INCREASE.get())).orElse(false);
                            WerewolfMinionEntity.WerewolfMinionData data = new WerewolfMinionEntity.WerewolfMinionData("Minion", this.getSkinType(), this.getEyeType(), this.hasGlowingEyes(), this.getForm(), hasIncreasedStats);
                            int id = controller.createNewMinionSlot((MinionData)data, (EntityType)ModEntities.WEREWOLF_MINION.get());
                            if (id < 0) {
                                LOGGER.error("Failed to get minion slot");
                                return;
                            }
                            WerewolfMinionEntity minion = (WerewolfMinionEntity)((EntityType)ModEntities.WEREWOLF_MINION.get()).create(this.level());
                            minion.claimMinionSlot(id, (PlayerMinionController)controller);
                            minion.copyPosition((Entity)this);
                            minion.markAsConverted();
                            controller.activateTask(0, (IMinionTask)MinionTasks.STAY.get());
                            UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                        } else {
                            LOGGER.warn("Wrong faction for minion");
                        }
                    } else {
                        LOGGER.warn("No free slot");
                    }
                });
            } else {
                LOGGER.error("Can't have minions");
            }
        });
    }

    public int getMaxEntityLevel() {
        return 2;
    }

    @Override
    public boolean canTransform() {
        return this.transformed != null;
    }

    public int suggestEntityLevel(de.teamlapen.vampirism.api.difficulty.Difficulty difficulty) {
        return switch (this.random.nextInt(5)) {
            case 0 -> (int)((float)difficulty.minPercLevel / 100.0f * 2.0f);
            case 1 -> (int)((float)difficulty.avgPercLevel / 100.0f * 2.0f);
            case 2 -> (int)((float)difficulty.maxPercLevel / 100.0f * 2.0f);
            default -> this.random.nextInt(3);
        };
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health.get() + (Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health_pl.get() * (double)l);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage.get() + (Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage_pl.get() * (double)l);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_speed.get()).doubleValue());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.getEntityData().get(SKINTYPE) == -1) {
            this.getEntityData().set(SKINTYPE, (Object)this.getRandom().nextInt(126));
        }
        if ((Integer)this.getEntityData().get(EYETYPE) == -1) {
            this.getEntityData().set(EYETYPE, (Object)this.getRandom().nextInt(126));
        }
    }

    public void setSourceEntity(WerewolfTransformable entity) {
        this.entityClass = entity.getEntityClass();
        this.entityTier = entity.getEntityTier();
        this.transformed = entity;
    }

    public void attackVillage(ICaptureAttributes iCaptureAttributes) {
        this.villageAttributes = iCaptureAttributes;
        this.attack = true;
    }

    public void defendVillage(ICaptureAttributes iCaptureAttributes) {
        this.villageAttributes = iCaptureAttributes;
        this.attack = false;
    }

    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ENTITY_WEREWOLF_GROWL.get();
    }

    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    public void stopVillageAttackDefense() {
        this.villageAttributes = null;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BreakDoorGoal((Mob)this, difficulty -> difficulty == Difficulty.HARD));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, new FollowAlphaWerewolfGoal<BasicWerewolfEntity>(this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, new WerewolfAttackVillageGoal<BasicWerewolfEntity>(this));
        this.targetSelector.addGoal(4, new WerewolfDefendVillageGoal<BasicWerewolfEntity>(this));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, true, null)));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey)StructureTags.VILLAGE)));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, new DefendLeaderGoal<BasicWerewolfEntity>(this));
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.getEntityData().define(LEVEL, (Object)-1);
        this.getEntityData().define(SKINTYPE, (Object)-1);
        this.getEntityData().define(EYETYPE, (Object)-1);
    }

    @Override
    @Nonnull
    public Optional<IEntityLeader> getLeader() {
        return Optional.ofNullable(this.entityLeader);
    }

    @Override
    public void setLeader(@Nullable IEntityLeader leader) {
        this.entityLeader = leader;
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                LupusSanguinemEffect.infectRandomByMob(living);
            }
            return true;
        }
        return false;
    }

    public static class Survivalist
    extends BasicWerewolfEntity {
        public Survivalist(EntityType<? extends Survivalist> type, Level world) {
            super(type, world);
        }

        @Override
        @NotNull
        public WerewolfForm getForm() {
            return WerewolfForm.SURVIVALIST;
        }
    }

    public static class Beast
    extends BasicWerewolfEntity {
        public Beast(EntityType<? extends Beast> type, Level world) {
            super(type, world);
        }

        @Override
        @NotNull
        public WerewolfForm getForm() {
            return WerewolfForm.BEAST;
        }

        public void die(@Nonnull DamageSource cause) {
            if (this.villageAttributes == null) {
                BadOmenEffect.handlePotentialBannerKill((Entity)cause.getEntity(), (IFactionEntity)this);
            }
            super.die(cause);
        }

        @Nullable
        public SpawnGroupData finalizeSpawn(@Nonnull ServerLevelAccessor world, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag nbt) {
            if (reason != MobSpawnType.SPAWN_EGG && reason != MobSpawnType.BUCKET && reason != MobSpawnType.CONVERSION && reason != MobSpawnType.COMMAND && this.getRandom().nextInt(50) == 0) {
                this.setItemSlot(EquipmentSlot.HEAD, WerewolfVillageData.createBanner());
            }
            return super.finalizeSpawn(world, difficulty, reason, spawnData, nbt);
        }
    }
}

