/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import de.teamlapen.lib.lib.client.gui.components.ScrollableArrayTextComponentList;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import de.teamlapen.werewolves.client.render.WerewolfMinionRenderer;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class WerewolfMinionAppearanceScreen
extends AppearanceScreen<WerewolfMinionEntity> {
    private static final Component NAME = Component.translatable((String)"gui.vampirism.minion_appearance");
    private int skinType;
    private int eyeType;
    private boolean glowingEyes;
    private ScrollableArrayTextComponentList skinList;
    private ScrollableArrayTextComponentList eyeList;
    private ExtendedButton skinButton;
    private ExtendedButton eyeButton;
    private Checkbox glowingEyeButton;
    private EditBox nameWidget;

    public WerewolfMinionAppearanceScreen(WerewolfMinionEntity entity, @Nullable Screen backScreen) {
        super(NAME, (LivingEntity)entity, backScreen);
    }

    protected void init() {
        super.init();
        this.nameWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.guiLeft + 21, this.guiTop + 29, 98, 12, (Component)Component.translatable((String)"gui.vampirism.minion_appearance.name")));
        this.nameWidget.setValue(((WerewolfMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.setTextColorUneditable(-1);
        this.nameWidget.setTextColor(-1);
        this.nameWidget.setMaxLength(15);
        this.nameWidget.setResponder(this::onNameChanged);
        int skinCount = ((WerewolfMinionRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((WerewolfMinionEntity)this.entity))).getSkinTextureCount(((WerewolfMinionEntity)this.entity).getForm());
        int eyeCount = ((WerewolfMinionRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((WerewolfMinionEntity)this.entity))).getEyeTextureCount(((WerewolfMinionEntity)this.entity).getForm());
        this.eyeType = ((WerewolfMinionEntity)this.entity).getEyeType();
        this.skinType = ((WerewolfMinionEntity)this.entity).getSkinType();
        this.glowingEyes = ((WerewolfMinionEntity)this.entity).hasGlowingEyes();
        this.glowingEyeButton = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 86, 99, 20, (Component)Component.translatable((String)"gui.werewolves.minion_appearance.glowing_eyes"), this.glowingEyes){

            public void onPress() {
                super.onPress();
                WerewolfMinionAppearanceScreen.this.glowingEyes = this.selected();
                ((WerewolfMinionEntity)WerewolfMinionAppearanceScreen.this.entity).setGlowingEyes(WerewolfMinionAppearanceScreen.this.glowingEyes);
            }
        });
        this.skinList = (ScrollableArrayTextComponentList)this.addRenderableWidget((GuiEventListener)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80, 20, skinCount, Component.translatable((String)"gui.vampirism.minion_appearance.skin"), this::setSkinType, this::previewSkin));
        this.eyeList = (ScrollableArrayTextComponentList)this.addRenderableWidget((GuiEventListener)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 64 + 19, 99, 60, 20, eyeCount, Component.translatable((String)"gui.vampirism.appearance.eye"), this::setEyeType, this::previewEye));
        this.skinButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.skinList.getX(), this.skinList.getY() - 20, this.skinList.getWidth() + 1, 20, (Component)Component.empty(), b -> this.setSkinListVisibility(!this.skinList.visible)));
        this.eyeButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.eyeList.getX(), this.eyeList.getY() - 20, this.eyeList.getWidth() + 1, 20, (Component)Component.empty(), b -> this.setHatListVisibility(!this.eyeList.visible)));
        this.setSkinListVisibility(false);
        this.setHatListVisibility(false);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.eyeList.mouseDragged(mouseX, mouseY, button, dragX, dragY) && !this.skinList.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void removed() {
        Object name = this.nameWidget.getValue();
        if (((String)name).isEmpty()) {
            name = Component.translatable((String)"text.vampirism.minion").toString() + String.valueOf(((WerewolfMinionEntity)this.entity).getMinionId().orElse(0));
        }
        VampirismMod.dispatcher.sendToServer((IMessage.IServerBoundMessage)new ServerboundAppearancePacket(((WerewolfMinionEntity)this.entity).getId(), (String)name, new int[]{this.skinType, this.eyeType, this.glowingEyes ? 1 : 0}));
        super.removed();
    }

    private void setEyeType(int type) {
        this.eyeType = type;
        ((WerewolfMinionEntity)this.entity).setEyeType(this.eyeType);
        this.setHatListVisibility(false);
    }

    private void setSkinType(int type) {
        this.skinType = type;
        ((WerewolfMinionEntity)this.entity).setSkinType(this.skinType);
        this.setSkinListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((WerewolfMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewEye(int type, boolean hovered) {
        if (hovered) {
            ((WerewolfMinionEntity)this.entity).setEyeType(type);
        } else if (((WerewolfMinionEntity)this.entity).getEyeType() == type) {
            ((WerewolfMinionEntity)this.entity).setEyeType(this.eyeType);
        }
    }

    private void previewSkin(int type, boolean hovered) {
        if (hovered) {
            ((WerewolfMinionEntity)this.entity).setSkinType(type);
        } else if (((WerewolfMinionEntity)this.entity).getSkinType() == type) {
            ((WerewolfMinionEntity)this.entity).setSkinType(this.skinType);
        }
    }

    private void setHatListVisibility(boolean show) {
        this.eyeButton.setMessage((Component)this.eyeList.getMessage().copy().append(" " + (this.eyeType + 1)));
        this.eyeList.visible = show;
        boolean bl = this.glowingEyeButton.visible = !show;
        if (show) {
            this.skinList.visible = false;
        }
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.setMessage((Component)this.skinList.getMessage().copy().append(" " + (this.skinType + 1)));
        this.skinList.visible = show;
        this.eyeButton.visible = !show;
        boolean bl = this.glowingEyeButton.visible = !show;
        if (show) {
            this.eyeList.visible = false;
        }
    }
}

