/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.api.entities.werewolf;

import de.teamlapen.werewolves.api.entities.werewolf.WerewolfSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;

public class WerewolfForm {
    private static final Map<String, WerewolfForm> REGISTRY = new HashMap<String, WerewolfForm>();
    public static final WerewolfForm NONE = new WerewolfForm("none", null, true, false, 0, 0.0f, true, 0.0f);
    public static final WerewolfForm HUMAN = new WerewolfForm("human", null, true, true, 3, 0.05f, true, 0.16f);
    public static final WerewolfForm BEAST = new WerewolfForm("beast", WerewolfSize.BEAST, false, true, 11, 0.2f, true, 0.32f);
    public static final WerewolfForm BEAST4L = new WerewolfForm("beast4l", WerewolfSize.BEAST, false, true, 11, 0.3f, false, 0.32f);
    public static final WerewolfForm SURVIVALIST = new WerewolfForm("survivalist", WerewolfSize.SURVIVAL, false, true, 11, 0.4f, false, 0.8f);
    @Nonnull
    private final String name;
    @Nullable
    private final Map<Pose, EntityDimensions> sizeMap;
    private final boolean humanLike;
    private final boolean transformed;
    private final int skinTypes;
    private final Component textComponent;
    private final float damageReduction;
    private final boolean hasArms;
    private final float leapModifier;

    WerewolfForm(@Nonnull String name, @Nullable Map<Pose, EntityDimensions> sizeMap, boolean humanLike, boolean transformed, int skinTypes, float damageReduction, boolean hasArms, float leapModifier) {
        if (REGISTRY.containsKey(name)) {
            throw new IllegalStateException("this name already exists");
        }
        REGISTRY.put(name, this);
        if (sizeMap == null) {
            sizeMap = new HashMap<Pose, EntityDimensions>();
        }
        this.name = name;
        this.sizeMap = sizeMap;
        this.humanLike = humanLike;
        this.transformed = transformed;
        this.skinTypes = skinTypes;
        this.textComponent = Component.translatable((String)("form.werewolves." + name));
        this.damageReduction = damageReduction;
        this.hasArms = hasArms;
        this.leapModifier = leapModifier;
    }

    public boolean isHumanLike() {
        return this.humanLike;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public Optional<EntityDimensions> getSize(Pose pose) {
        if (this.sizeMap != null) {
            return Optional.ofNullable(this.sizeMap.getOrDefault(pose, this.sizeMap.get(Pose.STANDING)));
        }
        return Optional.empty();
    }

    public Component getTextComponent() {
        return this.textComponent.plainCopy();
    }

    public int getSkinTypes() {
        return this.skinTypes;
    }

    public static WerewolfForm getForm(String name) {
        return REGISTRY.get(name);
    }

    public static Collection<WerewolfForm> getAllForms() {
        return new ArrayList<WerewolfForm>(REGISTRY.values());
    }

    public float getLeapModifier() {
        return this.leapModifier;
    }
}

