/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world;

import com.google.common.base.Preconditions;
import de.teamlapen.werewolves.world.ModDamageSources;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WerewolvesWorld {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Capability<WerewolvesWorld> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<WerewolvesWorld>(){});
    private final Level level;
    private final ModDamageSources damageSources;
    private final HashMap<Integer, WolfbaneEmitter> wolfsbaneEmitter = new HashMap();
    private final HashMap<ChunkPos, Integer> wolfsbaneDiffuser = new HashMap();

    @Deprecated
    @NotNull
    public static WerewolvesWorld get(@NotNull Level level) {
        return (WerewolvesWorld)level.getCapability(CAP).orElseThrow(() -> new IllegalStateException("Cannot get WerewolvesWorld from World " + String.valueOf(level)));
    }

    @NotNull
    public static LazyOptional<WerewolvesWorld> getOpt(@NotNull Level level) {
        LazyOptional opt = level.getCapability(CAP);
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get world capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    @NotNull
    public static ICapabilityProvider createNewCapability(final @NotNull Level level) {
        return new ICapabilitySerializable<CompoundTag>(){
            final WerewolvesWorld inst;
            final LazyOptional<WerewolvesWorld> opt;
            {
                this.inst = new WerewolvesWorld(level);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadNBTData(nbt);
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            @NotNull
            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveNBTData(tag);
                return tag;
            }
        };
    }

    public WerewolvesWorld(Level level) {
        this.level = level;
        this.damageSources = new ModDamageSources(level.registryAccess());
    }

    private void saveNBTData(CompoundTag nbt) {
    }

    private void loadNBTData(CompoundTag nbt) {
    }

    public int registerWolfsbaneDiffuserBlock(int amplifier, ChunkPos ... chunks) {
        Preconditions.checkArgument((boolean)Arrays.stream(chunks).allMatch(Objects::nonNull), (Object)"Wolfsbane emitter position cannot be null");
        WolfbaneEmitter emitter = new WolfbaneEmitter(amplifier, chunks);
        int hash = emitter.hashCode();
        this.wolfsbaneEmitter.put(hash, emitter);
        this.buildWolfsbaneSet();
        return hash;
    }

    public void removeWolfsbaneBlocksBlock(int id) {
        this.wolfsbaneEmitter.remove(id);
        this.buildWolfsbaneSet();
    }

    private void buildWolfsbaneSet() {
        this.wolfsbaneDiffuser.clear();
        this.wolfsbaneDiffuser.putAll(this.wolfsbaneEmitter.entrySet().stream().flatMap(e -> Arrays.stream(((WolfbaneEmitter)e.getValue()).chunks).map(l -> Pair.of((Object)l, (Object)((Integer)e.getKey())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (a, b) -> a > b ? a : b)));
    }

    public int isEffectedByWolfsbane(BlockPos pos) {
        Integer integer = this.wolfsbaneDiffuser.get(new ChunkPos(pos));
        return integer == null ? -1 : this.wolfsbaneEmitter.get((Object)integer).amplifier;
    }

    public ModDamageSources damageSources() {
        return this.damageSources;
    }

    private record WolfbaneEmitter(int amplifier, ChunkPos[] chunks) {
    }
}

