/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.items.IWerewolfArmor;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.effects.WolfsbaneEffect;
import de.teamlapen.werewolves.effects.inst.WerewolfNightVisionEffectInstance;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.player.werewolf.LevelHandler;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfInventory;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayerSpecialAttributes;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.mixin.ArmorItemAccessor;
import de.teamlapen.werewolves.mixin.FoodStatsAccessor;
import de.teamlapen.werewolves.mixin.entity.PlayerAccessor;
import de.teamlapen.werewolves.util.DamageHandler;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.NBTHelper;
import de.teamlapen.werewolves.util.Permissions;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WUtils;
import de.teamlapen.werewolves.world.WerewolvesWorld;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WerewolfPlayer
extends FactionBasePlayer<IWerewolfPlayer>
implements IWerewolfPlayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final UUID ARMOR_TOUGHNESS = UUID.fromString("f3979aec-b8ef-4e95-84a7-2c6dab8ea46e");
    private static final UUID CLAWS = UUID.fromString("70435284-afcd-4470-85c2-d9b36b3d94e8");
    public static final Capability<IWerewolfPlayer> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IWerewolfPlayer>(){});
    @Nonnull
    private final ActionHandler<IWerewolfPlayer> actionHandler;
    @Nonnull
    private final SkillHandler<IWerewolfPlayer> skillHandler;
    @Nonnull
    private final WerewolfPlayerSpecialAttributes specialAttributes = new WerewolfPlayerSpecialAttributes();
    @Nonnull
    private WerewolfForm form = WerewolfForm.NONE;
    @Nullable
    private WerewolfFormAction lastFormAction;
    @Nonnull
    private final LevelHandler levelHandler = new LevelHandler(this);
    private final Map<WerewolfForm, Integer> eyeType = new HashMap<WerewolfForm, Integer>();
    private final Map<WerewolfForm, Integer> skinType = new HashMap<WerewolfForm, Integer>();
    private final Map<WerewolfForm, Boolean> glowingEyes = new HashMap<WerewolfForm, Boolean>();
    private final WerewolfInventory inventory = new WerewolfInventory(this);
    private int sleepTimer;
    private int wolfsbaneCache = -1;

    public static WerewolfPlayer get(@Nonnull Player playerEntity) {
        return (WerewolfPlayer)playerEntity.getCapability(CAP).orElseThrow(() -> new IllegalStateException("Cannot get werewolf player capability from player" + String.valueOf(playerEntity)));
    }

    public static LazyOptional<WerewolfPlayer> getOpt(@Nonnull Player playerEntity) {
        LazyOptional opt = playerEntity.getCapability(CAP).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Werewolf player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static LazyOptional<WerewolfPlayer> getOptSave(Player player) {
        if (player == null || !player.isAlive()) {
            return LazyOptional.empty();
        }
        return WerewolfPlayer.getOpt(player);
    }

    public static LazyOptional<WerewolfPlayer> getOptEx(@Nullable Entity entity) {
        if (!(entity instanceof Player) || !Helper.isWerewolf((Player)entity)) {
            return LazyOptional.empty();
        }
        return WerewolfPlayer.getOpt((Player)entity);
    }

    public WerewolfPlayer(@Nonnull Player player) {
        super(player);
        this.actionHandler = new ActionHandler((IFactionPlayer)this);
        this.skillHandler = new SkillHandler((IFactionPlayer)this, WReference.WEREWOLF_FACTION);
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    public void setForm(WerewolfFormAction action, WerewolfForm form) {
        this.switchForm(form);
        this.lastFormAction = action;
        if (!this.player.level().isClientSide) {
            this.sync(NBTHelper.nbtWith(nbt -> nbt.putString("form", this.form.getName())), true);
        }
    }

    public WerewolfInventory getInventory() {
        return this.inventory;
    }

    public void switchForm(WerewolfForm form) {
        if (this.form == form) {
            return;
        }
        this.form = form;
        this.player.refreshDimensions();
        if (!this.form.isHumanLike()) {
            ((PlayerAccessor)this.player).invoke_removeEntitiesOnShoulder();
        }
        if (!this.player.level().isClientSide) {
            this.inventory.swapArmorItems(form);
        }
        this.checkToolDamage(this.player.getMainHandItem(), this.player.getMainHandItem(), true);
    }

    @Override
    public boolean canWearArmor(ItemStack stack) {
        return this.canWearArmor(this.form, stack);
    }

    public boolean canWearArmor(List<ItemStack> stacks) {
        return stacks.stream().allMatch(this::canWearArmor);
    }

    public boolean canWearArmor(WerewolfForm form, List<ItemStack> stack) {
        return stack.stream().allMatch(s -> this.canWearArmor(form, (ItemStack)s));
    }

    public boolean canWearArmor(WerewolfForm form, ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        Item item = stack.getItem();
        if (item instanceof IWerewolfArmor) {
            IWerewolfArmor armor = (IWerewolfArmor)item;
            return armor.canWear(this, form);
        }
        return form.isHumanLike() && (!form.isTransformed() || this.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WEAR_ARMOR.get()));
    }

    protected FactionBasePlayer<IWerewolfPlayer> copyFromPlayer(Player playerEntity) {
        WerewolfPlayer oldWerewolf = WerewolfPlayer.get(playerEntity);
        CompoundTag nbt = new CompoundTag();
        oldWerewolf.saveData(nbt);
        this.loadData(nbt);
        return oldWerewolf;
    }

    public void removeArmorModifier() {
        for (UUID uuid : ArmorItemAccessor.getARMOR_MODIFIERS().values()) {
            this.player.getAttribute(Attributes.ARMOR_TOUGHNESS).removeModifier(uuid);
            this.player.getAttribute(Attributes.ARMOR).removeModifier(uuid);
        }
    }

    public void addArmorModifier() {
        HashSet uuids = Sets.newHashSet(ArmorItemAccessor.getARMOR_MODIFIERS().values());
        int i = 0;
        for (ItemStack stack : this.player.getArmorSlots()) {
            EquipmentSlot slotType = EquipmentSlot.byTypeAndIndex((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i++);
            Multimap map = stack.getAttributeModifiers(slotType);
            for (Map.Entry entry : map.asMap().entrySet()) {
                for (AttributeModifier modifier : (Collection)entry.getValue()) {
                    AttributeInstance attribute;
                    if (!uuids.contains(modifier.getId()) || (attribute = this.player.getAttribute((Attribute)entry.getKey())).hasModifier(modifier)) continue;
                    attribute.addPermanentModifier(modifier);
                }
            }
        }
    }

    public void onChangedDimension(ResourceKey<Level> registryKey, ResourceKey<Level> registryKey1) {
    }

    @Nonnull
    public WerewolfPlayerSpecialAttributes getSpecialAttributes() {
        return this.specialAttributes;
    }

    public void onUpdate() {
        this.player.getCommandSenderWorld().getProfiler().push("werewolves_werewolfplayer");
        super.onUpdate();
        if (this.getLevel() > 0) {
            if (!this.isRemote()) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundTag syncPacket = new CompoundTag();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    syncToAll = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (this.player.level().getGameTime() % 10L == 0L) {
                    if (this.specialAttributes.transformationTime > 0.0 && !FormHelper.isFormActionActive(this)) {
                        this.specialAttributes.transformationTime = Mth.clamp((double)(this.specialAttributes.transformationTime - this.player.getAttribute((Attribute)ModAttributes.TIME_REGAIN.get()).getValue()), (double)0.0, (double)1.0);
                        syncPacket.putDouble("transformationTime", this.specialAttributes.transformationTime);
                    }
                    if (this.player.level().getGameTime() % 20L == 0L) {
                        if (Helper.isFullMoon(this.getRepresentingPlayer().getCommandSenderWorld()) && !FormHelper.isFormActionActive(this) && !this.skillHandler.isSkillEnabled((ISkill)ModSkills.FREE_WILL.get())) {
                            Optional<WerewolfFormAction> action = this.lastFormAction != null ? Optional.of(this.lastFormAction) : WerewolfFormAction.getAllAction().stream().filter(arg_0 -> this.actionHandler.isActionUnlocked(arg_0)).findAny();
                            action.ifPresent(a -> this.actionHandler.toggleAction(a, (IAction.ActivationContext)new ActionHandler.ActivationContext()));
                        }
                        if (this.player.isInWater() && this.player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !this.skillHandler.isSkillEnabled((ISkill)ModSkills.WATER_LOVER.get())) {
                            this.player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 50, 0, true, true));
                        }
                    }
                }
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.HEALTH_REG.get())) {
                    this.tickFoodStats();
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                MobEffectInstance effect = this.player.getEffect(MobEffects.NIGHT_VISION);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision) {
                    if (!(effect instanceof WerewolfNightVisionEffectInstance)) {
                        if (effect != null) {
                            this.player.removeEffectNoUpdate(effect.getEffect());
                        }
                        this.player.addEffect((MobEffectInstance)new WerewolfNightVisionEffectInstance(effect));
                    }
                } else if (effect instanceof WerewolfNightVisionEffectInstance) {
                    this.player.removeEffect(effect.getEffect());
                    effect = ((EffectInstanceWithSource)effect).getHiddenEffect();
                    if (effect != null) {
                        this.player.addEffect(effect);
                    }
                }
                if (this.player.tickCount % 40 == 0 && this.isAffectedByWolfsbane((LevelAccessor)this.player.level(), true)) {
                    this.player.addEffect(WolfsbaneEffect.createWolfsbaneEffect((LivingEntity)this.player, 50, this.wolfsbaneCache));
                }
            } else {
                this.actionHandler.updateActions();
                if (this.player.level().getGameTime() % 10L == 0L && this.specialAttributes.transformationTime > 0.0 && !FormHelper.isFormActionActive(this)) {
                    this.specialAttributes.transformationTime = Mth.clamp((double)(this.specialAttributes.transformationTime - (double)((float)this.player.getAttribute((Attribute)ModAttributes.TIME_REGAIN.get()).getValue())), (double)0.0, (double)1.0);
                }
                MobEffectInstance effect = this.player.getEffect(MobEffects.NIGHT_VISION);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision && !(effect instanceof WerewolfNightVisionEffectInstance)) {
                    this.player.removeEffectNoUpdate(MobEffects.NIGHT_VISION);
                    this.player.addEffect((MobEffectInstance)new WerewolfNightVisionEffectInstance());
                }
            }
            this.specialAttributes.biteTicks = Math.max(0, this.specialAttributes.biteTicks - 1);
        } else if (!this.isRemote() && this.player.isSleeping() && this.player.hasEffect((MobEffect)ModEffects.LUPUS_SANGUINEM.get())) {
            if (this.sleepTimer++ >= 200) {
                this.player.getEffect((MobEffect)ModEffects.LUPUS_SANGUINEM.get()).applyEffect((LivingEntity)this.player);
                this.player.removeEffect((MobEffect)ModEffects.LUPUS_SANGUINEM.get());
                this.player.stopSleeping();
            }
        } else {
            this.sleepTimer = 0;
        }
        this.player.getCommandSenderWorld().getProfiler().pop();
    }

    private void tickFoodStats() {
        FoodData stats = this.player.getFoodData();
        ((FoodStatsAccessor)stats).setTickTimer(((FoodStatsAccessor)stats).getTickTimer() + 1);
    }

    public boolean setGlowingEyes(WerewolfForm form, boolean on) {
        if (on != this.glowingEyes.getOrDefault(form, false)) {
            this.glowingEyes.put(form, on);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag glowingEyes = new CompoundTag();
                this.glowingEyes.forEach((key, value) -> glowingEyes.putBoolean(key.getName(), value.booleanValue()));
                nbt.put("glowingEyes", (Tag)glowingEyes);
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setEyeType(WerewolfForm form, int type) {
        if (type != this.eyeType.getOrDefault(form, -1)) {
            this.eyeType.put(form, type);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag eye = new CompoundTag();
                this.eyeType.forEach((key, value) -> eye.putInt(key.getName(), value.intValue()));
                nbt.put("eyeTypes", (Tag)eye);
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setSkinType(WerewolfForm form, int type) {
        if (type != this.skinType.getOrDefault(form, -1)) {
            this.skinType.put(form, type);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag skin = new CompoundTag();
                this.skinType.forEach((key, value) -> skin.putInt(key.getName(), value.intValue()));
                nbt.put("skinTypes", (Tag)skin);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void setSkinData(WerewolfForm form, int[] data) {
        this.setEyeType(form, data[0]);
        this.setSkinType(form, data[1]);
        this.setGlowingEyes(form, data[2] == 1);
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        this.actionHandler.deactivateAllActions();
    }

    @Nonnull
    public LevelHandler getLevelHandler() {
        return this.levelHandler;
    }

    public boolean onEntityAttacked(DamageSource damageSource, float v) {
        return false;
    }

    public void onEntityKilled(LivingEntity victim, DamageSource src) {
        if (this.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.RAGE_FURY.get())) {
            this.player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 40, 1));
            this.actionHandler.extendActionTimer((ILastingAction)ModActions.RAGE.get(), ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.rage_fury_timer_extend.get()).intValue());
        }
        this.levelHandler.increaseProgress((int)((double)victim.getMaxHealth() * 0.2));
        this.syncLevelHandler();
    }

    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    public void syncLevelHandler() {
        CompoundTag sync = new CompoundTag();
        this.levelHandler.saveToNbt(sync);
        this.sync(sync, false);
    }

    public void onPlayerLoggedIn() {
    }

    public void onPlayerLoggedOut() {
    }

    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    public boolean canBiteEntity(LivingEntity entity) {
        return (double)entity.distanceTo((Entity)this.player) <= this.player.getAttribute((Attribute)ForgeMod.BLOCK_REACH.get()).getValue() + 1.0 && (!(entity instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.BITE_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false);
    }

    public boolean canBite() {
        return this.form.isTransformed() && !this.player.isSpectator() && this.getLevel() > 0 && this.specialAttributes.biteTicks <= 0 && (!(this.player instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.BITE, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false);
    }

    public boolean bite(int entityId) {
        Entity entity = this.player.level().getEntity(entityId);
        if (entity instanceof LivingEntity) {
            return this.bite((LivingEntity)entity);
        }
        return false;
    }

    private boolean bite(LivingEntity entity) {
        if (this.specialAttributes.biteTicks > 0) {
            return false;
        }
        if (!this.form.isTransformed()) {
            return false;
        }
        if (!this.canBite()) {
            return false;
        }
        if (!this.canBiteEntity(entity)) {
            return false;
        }
        double damage = this.player.getAttribute((Attribute)ModAttributes.BITE_DAMAGE.get()).getValue();
        boolean flag = DamageHandler.hurtModded((Entity)entity, sources -> sources.bite((LivingEntity)this.player), (float)damage);
        if (flag) {
            this.getRepresentingPlayer().playSound((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), 1.0f, 1.0f);
            this.getRepresentingPlayer().playNotifySound((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.eatEntity(entity);
            this.specialAttributes.biteTicks = (Integer)WerewolvesConfig.BALANCE.PLAYER.bite_cooldown.get();
            if (!this.getForm().isHumanLike()) {
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.STUN_BITE.get())) {
                    int duration = (Integer)WerewolvesConfig.BALANCE.SKILLS.stun_bite_duration.get();
                    if (this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.STUN_BITE.get())) {
                        duration += ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.stun_bite_duration_extend.get()).intValue();
                    }
                    entity.addEffect(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), duration));
                }
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.BLEEDING_BITE.get())) {
                    entity.addEffect(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), ((Integer)WerewolvesConfig.BALANCE.SKILLS.bleeding_bite_duration.get()).intValue(), this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.BLEEDING_BITE.get()) ? 3 : 0));
                }
            }
            this.sync(NBTHelper.nbtWith(nbt -> nbt.putInt("biteTicks", this.specialAttributes.biteTicks)), false);
            if (!(entity instanceof ServerPlayer) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.INFECT_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
                LupusSanguinemEffect.infectRandomByPlayer(entity);
            }
        }
        return flag;
    }

    private void eatEntity(LivingEntity entity) {
        if (!Helper.isNoLiving(entity)) {
            return;
        }
        if (!entity.isAlive()) {
            this.player.getFoodData().eat(1, 1.0f);
        }
    }

    public void onLevelChanged(int newLevel, int oldLevel) {
        super.onLevelChanged(newLevel, oldLevel);
        this.applyEntityAttributes();
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard((Player)this.player, (ObjectiveCriteria)WUtils.WEREWOLF_LEVEL_CRITERIA, (int)newLevel);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.MOVEMENT_SPEED, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.3, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.ARMOR_TOUGHNESS, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.ATTACK_DAMAGE, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_damage.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)false);
            if (newLevel > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill((ISkillType)SkillType.LEVEL);
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
            }
        } else if (newLevel == 0) {
            this.actionHandler.resetTimers();
        }
    }

    public boolean isAffectedByWolfsbane(LevelAccessor accessor, boolean forceRefresh) {
        if (forceRefresh) {
            int n;
            if (accessor instanceof Level) {
                Level level = (Level)accessor;
                n = WerewolvesWorld.getOpt(level).map(x -> x.isEffectedByWolfsbane(this.getRepresentingPlayer().blockPosition())).orElse(-1);
            } else {
                n = -1;
            }
            this.wolfsbaneCache = n;
        }
        return this.wolfsbaneCache > -1;
    }

    private void eatFleshFrom(LivingEntity entity) {
        this.player.getFoodData().eat(1, 1.0f);
    }

    public ResourceLocation getCapKey() {
        return REFERENCE.WEREWOLF_PLAYER_KEY;
    }

    public boolean canLeaveFaction() {
        return true;
    }

    @Nullable
    public IFaction<?> getDisguisedAs() {
        if (this.getForm().isTransformed()) {
            return WReference.WEREWOLF_FACTION;
        }
        return null;
    }

    public Optional<Tier> getDigDropTier() {
        return Optional.ofNullable(this.specialAttributes.diggerTier);
    }

    public float getDigSpeed() {
        return this.specialAttributes.diggingSpeed;
    }

    public int getMaxLevel() {
        return 14;
    }

    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate((IFaction)this.getFaction(), ignoreDisguise);
    }

    public boolean isDisguised() {
        return !this.getForm().isTransformed();
    }

    @Nullable
    public WerewolfFormAction getLastFormAction() {
        return this.lastFormAction;
    }

    public ISkillHandler<IWerewolfPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    public IActionHandler<IWerewolfPlayer> getActionHandler() {
        return this.actionHandler;
    }

    public void saveData(CompoundTag compound) {
        super.saveData(compound);
        compound.put("inventory", (Tag)this.inventory.save());
        this.skillHandler.saveToNbt(compound);
        this.actionHandler.saveToNbt(compound);
        this.levelHandler.saveToNbt(compound);
        compound.putString("form", this.form.getName());
        if (this.lastFormAction != null) {
            compound.putString("lastFormAction", RegUtil.id((IAction)this.lastFormAction).toString());
        }
        compound.putInt("biteTicks", this.specialAttributes.biteTicks);
        CompoundTag eye = new CompoundTag();
        this.eyeType.forEach((key, value) -> eye.putInt(key.getName(), value.intValue()));
        compound.put("eyeTypes", (Tag)eye);
        CompoundTag skin = new CompoundTag();
        this.skinType.forEach((key, value) -> skin.putInt(key.getName(), value.intValue()));
        compound.put("skinTypes", (Tag)skin);
        CompoundTag glowingEye = new CompoundTag();
        this.glowingEyes.forEach((key, value) -> glowingEye.putBoolean(key.getName(), value.booleanValue()));
        compound.put("glowingEyes", (Tag)glowingEye);
        compound.putDouble("transformationTime", this.specialAttributes.transformationTime);
        ListTag armor = new ListTag();
    }

    public void loadData(CompoundTag compound) {
        super.loadData(compound);
        this.inventory.load(compound.getCompound("inventory"));
        this.skillHandler.loadFromNbt(compound);
        this.actionHandler.loadFromNbt(compound);
        this.levelHandler.loadFromNbt(compound);
        CompoundTag armor = compound.getCompound("armor");
        for (int i = 0; i < armor.size(); ++i) {
            try {
                ItemStack stack = ItemStack.of((CompoundTag)armor.getCompound("" + i));
                this.player.setItemSlot(EquipmentSlot.values()[i], stack);
                continue;
            }
            catch (Exception stack) {
                // empty catch block
            }
        }
        if (NBTHelper.containsString(compound, "lastFormAction")) {
            this.lastFormAction = (WerewolfFormAction)RegUtil.getAction((ResourceLocation)new ResourceLocation(compound.getString("lastFormAction")));
        }
        this.specialAttributes.biteTicks = compound.getInt("biteTicks");
        CompoundTag eye = compound.getCompound("eyeTypes");
        eye.getAllKeys().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.getInt(string)));
        CompoundTag skin = compound.getCompound("skinTypes");
        skin.getAllKeys().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.getInt(string)));
        CompoundTag glowingEyes = compound.getCompound("glowingEyes");
        glowingEyes.getAllKeys().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.getBoolean(string)));
        if (compound.contains("transformationTime")) {
            this.specialAttributes.transformationTime = compound.getFloat("transformationTime");
        }
    }

    protected void writeFullUpdate(CompoundTag nbt) {
        super.writeFullUpdate(nbt);
        nbt.put("inventory", (Tag)this.inventory.save());
        this.skillHandler.writeUpdateForClient(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.levelHandler.saveToNbt(nbt);
        nbt.putString("form", this.form.getName());
        nbt.putInt("biteTicks", this.specialAttributes.biteTicks);
        CompoundTag eye = new CompoundTag();
        this.eyeType.forEach((key, value) -> eye.putInt(key.getName(), value.intValue()));
        nbt.put("eyeTypes", (Tag)eye);
        CompoundTag skin = new CompoundTag();
        this.skinType.forEach((key, value) -> skin.putInt(key.getName(), value.intValue()));
        nbt.put("skinTypes", (Tag)skin);
        CompoundTag glowingEye = new CompoundTag();
        this.glowingEyes.forEach((key, value) -> glowingEye.putBoolean(key.getName(), value.booleanValue()));
        nbt.put("glowingEyes", (Tag)glowingEye);
        nbt.putDouble("transformationTime", this.specialAttributes.transformationTime);
    }

    protected void loadUpdate(CompoundTag nbt) {
        super.loadUpdate(nbt);
        this.inventory.load(nbt.getCompound("inventory"));
        this.skillHandler.readUpdateFromServer(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.levelHandler.loadFromNbt(nbt);
        if (NBTHelper.containsString(nbt, "form")) {
            this.switchForm(this.form);
        }
        if (nbt.contains("biteTicks")) {
            this.specialAttributes.biteTicks = nbt.getInt("biteTicks");
        }
        if (nbt.contains("eyeTypes")) {
            CompoundTag eye = nbt.getCompound("eyeTypes");
            eye.getAllKeys().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.getInt(string)));
        }
        if (nbt.contains("skinTypes")) {
            CompoundTag skin = nbt.getCompound("skinTypes");
            skin.getAllKeys().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.getInt(string)));
        }
        if (nbt.contains("glowingEyes")) {
            CompoundTag glowingEyes = nbt.getCompound("glowingEyes");
            glowingEyes.getAllKeys().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.getBoolean(string)));
        }
        if (nbt.contains("transformationTime")) {
            this.specialAttributes.transformationTime = nbt.getFloat("transformationTime");
        }
    }

    private void applyEntityAttributes() {
        try {
            this.player.getAttribute((Attribute)ModAttributes.BITE_DAMAGE.get());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public static ICapabilityProvider createNewCapability(final Player player) {
        return new ICapabilitySerializable<CompoundTag>(){
            final WerewolfPlayer inst;
            final LazyOptional<IWerewolfPlayer> opt;
            {
                this.inst = new WerewolfPlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CAP.orEmpty(cap, this.opt);
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveData(tag);
                return tag;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadData(nbt);
            }
        };
    }

    public void checkToolDamage(@NotNull ItemStack from, @NotNull ItemStack itemInHand, boolean forceCalculation) {
        AttributeInstance attribute = this.player.getAttribute(Attributes.ATTACK_DAMAGE);
        if (this.getLevel() > 0 && this.form.isTransformed() && itemInHand.isEmpty()) {
            if (!from.isEmpty() || forceCalculation) {
                float damage = ((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_claw_damage.get()).floatValue();
                if (this.specialAttributes.diggerTier != null) {
                    damage += (1.0f + this.specialAttributes.diggerTier.getAttackDamageBonus()) / 2.0f;
                }
                attribute.removeModifier(CLAWS);
                attribute.addTransientModifier(new AttributeModifier(CLAWS, "werewolf_claws", (double)damage, AttributeModifier.Operation.ADDITION));
            }
        } else {
            attribute.removeModifier(CLAWS);
        }
    }

    public void checkWerewolfFormModifier() {
        WerewolfFormAction.getAllAction().stream().filter(action -> this.getActionHandler().isActionActive((ILastingAction)action)).findAny().ifPresent(action -> action.checkDayNightModifier(this));
    }

    @Override
    public int getEyeType(WerewolfForm form) {
        return this.eyeType.getOrDefault(form, 0);
    }

    @Override
    public int getSkinType(WerewolfForm form) {
        return this.skinType.getOrDefault(form, 0);
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return this.glowingEyes.getOrDefault(form, false);
    }

    public void dropEquipment() {
        this.inventory.dropEquipment();
    }

    @Override
    public void updateMinionAttributes(boolean increasedStats) {
        MinionWorldData.getData((Level)this.player.level()).flatMap(a -> FactionPlayerHandler.getOpt((Player)this.player).map(arg_0 -> ((MinionWorldData)a).getOrCreateController(arg_0))).ifPresent(controller -> controller.contactMinions(minion -> {
            minion.getMinionData().ifPresent(b -> ((WerewolfMinionEntity.WerewolfMinionData)((Object)((Object)((Object)b)))).setIncreasedStats(increasedStats));
            HelperLib.sync((Entity)minion);
        }));
    }

    static {
        LevelAttributeModifier.registerModdedAttributeModifier((Attribute)Attributes.ARMOR_TOUGHNESS, (UUID)ARMOR_TOUGHNESS);
    }
}

