/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import de.teamlapen.werewolves.entities.player.werewolf.WerewolfLevelConf;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public class LevelHandler {
    private final WerewolfPlayer player;
    private int levelProgress;

    public LevelHandler(WerewolfPlayer player) {
        this.player = player;
    }

    public boolean canLevelUp() {
        return this.player.getLevel() != this.player.getMaxLevel() && this.levelProgress >= this.getNeededProgress();
    }

    public float getLevelPerc() {
        return Mth.clamp((float)((float)this.levelProgress / (float)this.getNeededProgress()), (float)0.0f, (float)1.0f);
    }

    public void saveToNbt(@Nonnull CompoundTag compound) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("progress", this.levelProgress);
        compound.put("level", (Tag)nbt);
    }

    public void loadFromNbt(@Nonnull CompoundTag compound) {
        if (compound.contains("level")) {
            this.levelProgress = compound.getCompound("level").getInt("progress");
        }
    }

    public int getLevelProgress() {
        return this.levelProgress;
    }

    public int getNeededProgress() {
        return WerewolfLevelConf.getInstance().getRequirementOpt(this.player.getLevel() + 1).map(x -> x.xpAmount).orElse(Integer.MAX_VALUE);
    }

    public void increaseProgress(int amount) {
        this.levelProgress += amount;
    }

    public void reset() {
        this.levelProgress = 0;
    }
}

