/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.teamlapen.werewolves.blocks.StoneAltarBlock;
import de.teamlapen.werewolves.blocks.entity.StoneAltarBlockEntity;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.items.LiverItem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StoneAltarTESR
implements BlockEntityRenderer<StoneAltarBlockEntity> {
    private static final ItemStack LIVER_STACK = ((LiverItem)((Object)ModItems.LIVER.get())).getDefaultInstance();
    private static final ItemStack BONE_STACK = ((Item)ModItems.CRACKED_BONE.get()).getDefaultInstance();

    public StoneAltarTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull StoneAltarBlockEntity tileEntityIn, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.getItem(0).isEmpty()) {
            this.renderItem(tileEntityIn, matrixStackIn);
            matrixStackIn.translate(-0.5, 0.0, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(22.5f));
            matrixStackIn.mulPose(Axis.XN.rotationDegrees(90.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(LIVER_STACK, ItemDisplayContext.GUI, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, tileEntityIn.getLevel(), 0);
            matrixStackIn.popPose();
        }
        if (!tileEntityIn.getItem(1).isEmpty()) {
            this.renderItem(tileEntityIn, matrixStackIn);
            matrixStackIn.translate(0.5, 0.0, 0.5);
            matrixStackIn.mulPose(Axis.YN.rotationDegrees(22.5f));
            matrixStackIn.mulPose(Axis.XN.rotationDegrees(90.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(BONE_STACK, ItemDisplayContext.GUI, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, tileEntityIn.getLevel(), 0);
            matrixStackIn.popPose();
        }
    }

    private void renderItem(@Nonnull StoneAltarBlockEntity tileEntityIn, @Nonnull PoseStack matrixStackIn) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 0.64, 0.5);
        matrixStackIn.scale(0.4f, 0.4f, 0.4f);
        switch ((Direction)tileEntityIn.getBlockState().getValue((Property)StoneAltarBlock.HORIZONTAL_FACING)) {
            case WEST: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(270.0f));
            }
        }
    }
}

