/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.gui.WerewolfPlayerAppearanceScreen;
import de.teamlapen.werewolves.client.render.player.WerewolfPlayerBeastRenderer;
import de.teamlapen.werewolves.client.render.player.WerewolfPlayerSurvivalistRenderer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ModPlayerRenderer {
    private final WerewolfPlayerBeastRenderer beastRenderer;
    private final WerewolfPlayerSurvivalistRenderer survivalistRenderer;

    public ModPlayerRenderer(EntityRendererProvider.Context context) {
        this.beastRenderer = new WerewolfPlayerBeastRenderer(context);
        this.survivalistRenderer = new WerewolfPlayerSurvivalistRenderer(context);
    }

    public boolean renderPlayer(AbstractClientPlayer player, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        return this.render(player, x -> {
            if (x == WerewolfForm.SURVIVALIST) {
                this.survivalistRenderer.render((LivingEntity)player, entityYaw, partialTicks, stack, buffer, packedLight);
                return true;
            }
            if (x == WerewolfForm.BEAST) {
                this.beastRenderer.render((LivingEntity)player, entityYaw, partialTicks, stack, buffer, packedLight);
                return true;
            }
            return false;
        });
    }

    private boolean render(AbstractClientPlayer player, Function<WerewolfForm, Boolean> renderFunction) {
        WerewolfPlayerAppearanceScreen screen;
        WerewolfForm form = WerewolfPlayer.getOpt((Player)player).map(WerewolfPlayer::getForm).orElse(WerewolfForm.NONE);
        Screen screen2 = Minecraft.getInstance().screen;
        if (screen2 instanceof WerewolfPlayerAppearanceScreen && (screen = (WerewolfPlayerAppearanceScreen)screen2).isRenderForm()) {
            form = screen.getActiveForm();
        }
        if (form.isTransformed() && !form.isHumanLike()) {
            return renderFunction.apply(form);
        }
        return false;
    }

    public boolean renderArm(AbstractClientPlayer player, PoseStack stack, MultiBufferSource bufferSource, int pCombinedLight, HumanoidArm arm) {
        return this.render(player, form -> {
            if (form == WerewolfForm.SURVIVALIST) {
                if (arm == HumanoidArm.LEFT) {
                    this.survivalistRenderer.renderLeftHand(stack, bufferSource, pCombinedLight, player);
                } else {
                    this.survivalistRenderer.renderRightHand(stack, bufferSource, pCombinedLight, player);
                }
                return true;
            }
            if (form == WerewolfForm.BEAST) {
                if (arm == HumanoidArm.LEFT) {
                    this.beastRenderer.renderLeftHand(stack, bufferSource, pCombinedLight, player);
                } else {
                    this.beastRenderer.renderRightHand(stack, bufferSource, pCombinedLight, player);
                }
                return true;
            }
            return false;
        });
    }

    public boolean renderArmMap(AbstractClientPlayer player, PoseStack stack, MultiBufferSource bufferSource, int pCombinedLight, HumanoidArm arm) {
        return this.render(player, form -> true);
    }
}

