/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import de.teamlapen.werewolves.util.WUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StoneAltarFireBowlBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final String REG_NAME = "stone_altar_fire_bowl";
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty SOUL_FIRE = WUtils.SOUL_FIRE;
    protected static final VoxelShape SHAPE = StoneAltarFireBowlBlock.makeShape();

    public StoneAltarFireBowlBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? 14 : 0));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.SIGNAL_FIRE, (Comparable)Boolean.valueOf(false)));
    }

    protected static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
        VoxelShape b = Block.box((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
        VoxelShape c = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c});
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public InteractionResult use(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult p_225533_6_) {
        ItemStack stack;
        if (!(((Boolean)state.getValue((Property)LIT)).booleanValue() || (stack = player.getItemInHand(handIn)).getItem() != Items.TORCH && stack.getItem() != Items.SOUL_TORCH || ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue())) {
            worldIn.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(stack.getItem() == Items.SOUL_TORCH)));
            return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT}).add(new Property[]{WATERLOGGED}).add(new Property[]{SOUL_FIRE}).add(new Property[]{FACING}).add(new Property[]{BlockStateProperties.SIGNAL_FIRE});
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isBurning(BlockState state, BlockGetter world, BlockPos pos) {
        return super.isBurning(state, world, pos);
    }

    public boolean placeLiquid(@Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluidState fluid) {
        if (super.placeLiquid(world, pos, state, fluid)) {
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
                if (world.isClientSide()) {
                    for (int i = 0; i < 20; ++i) {
                        CampfireBlock.makeParticles((Level)((Level)world), (BlockPos)pos.above(1), (boolean)false, (boolean)true);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.getX() + rand.nextDouble();
            double d1 = (double)pos.getY() + rand.nextDouble() + 0.7;
            double d2 = (double)pos.getZ() + rand.nextDouble();
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }
}

