/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.items;

import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrossbowArrowItem
extends ArrowItem
implements IVampirismCrossbowArrow<CrossbowArrowEntity> {
    private final ArrowType type;

    public CrossbowArrowItem(ArrowType type) {
        super(new Item.Properties());
        this.type = type;
    }

    @NotNull
    public AbstractArrow m_6394_(@NotNull Level level, @NotNull ItemStack stack, @NotNull LivingEntity entity) {
        CrossbowArrowEntity arrowEntity = new CrossbowArrowEntity(level, entity, stack);
        arrowEntity.setEffectsFromItem(stack);
        arrowEntity.m_36781_((double)this.type.baseDamage * (Double)VampirismConfig.BALANCE.crossbowDamageMult.get());
        return arrowEntity;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (this.type.hasToolTip) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
        }
    }

    public ArrowType getType() {
        return this.type;
    }

    public boolean isCanBeInfinite() {
        return this.type.canBeInfinit;
    }

    public void onHitBlock(ItemStack arrow, BlockPos blockPos, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        this.type.onHitBlock(arrow, blockPos, arrowEntity, shootingEntity);
    }

    public void onHitEntity(ItemStack arrow, LivingEntity entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        this.type.onHitEntity(arrow, entity, arrowEntity, shootingEntity);
    }

    public static class ArrowType {
        public final String name;
        public final int baseDamage;
        public final int color;
        public final boolean canBeInfinit;
        public final boolean hasToolTip;

        public ArrowType(String name, int baseDamage, int color, boolean canBeInfinit, boolean hasToolTip) {
            this.name = name;
            this.baseDamage = baseDamage;
            this.color = color;
            this.canBeInfinit = canBeInfinit;
            this.hasToolTip = hasToolTip;
        }

        private void onHitBlock(ItemStack arrow, BlockPos blockPos, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        }

        public void onHitEntity(ItemStack arrow, LivingEntity entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        }
    }
}

