/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.world.gen.modifier.ExtendedAddSpawnsBiomeModifier;
import de.teamlapen.werewolves.blocks.LeavesBlock;
import de.teamlapen.werewolves.blocks.LogBlock;
import de.teamlapen.werewolves.blocks.WolfBerryBushBlock;
import de.teamlapen.werewolves.config.CommonConfig;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.world.gen.ConfigIntProvider;
import de.teamlapen.werewolves.world.gen.feature.MagicFoliagePlacer;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.MegaPineFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.CherryTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class WerewolvesBiomeFeatures {
    public static final DeferredRegister<IntProviderType<?>> INT_PROVIDER = DeferredRegister.create((ResourceKey)Registries.INT_PROVIDER_TYPE, (String)"werewolves");
    public static final RegistryObject<IntProviderType<ConfigIntProvider>> CONFIG_INT_PROVIDER = INT_PROVIDER.register("config_int_provider", () -> () -> ConfigIntProvider.CODEC);
    public static final ResourceKey<ConfiguredFeature<?, ?>> JACARANDA_TREE = WerewolvesBiomeFeatures.createConfiguredKey("jacaranda_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAGIC_TREE = WerewolvesBiomeFeatures.createConfiguredKey("magic_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WOLFSBANE = WerewolvesBiomeFeatures.createConfiguredKey("wolfsbane");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE = WerewolvesBiomeFeatures.createConfiguredKey("silver_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GIANT_SPRUCE_TREE = WerewolvesBiomeFeatures.createConfiguredKey("giant_spruce_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEAD_SPRUCE_TREE = WerewolvesBiomeFeatures.createConfiguredKey("dead_spruce_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEREWOLF_HEAVEN_TREES = WerewolvesBiomeFeatures.createConfiguredKey("werewolf_heaven_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WOLF_BERRY_BUSH = WerewolvesBiomeFeatures.createConfiguredKey("wolf_berry_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FOREST_ROCK = WerewolvesBiomeFeatures.createConfiguredKey("forest_rock");
    public static final ResourceKey<PlacedFeature> JACARANDA_TREE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("jacaranda_tree");
    public static final ResourceKey<PlacedFeature> MAGIC_TREE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("magic_tree");
    public static final ResourceKey<PlacedFeature> GIANT_SPRUCE_TREE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("giant_spruce_tree");
    public static final ResourceKey<PlacedFeature> DEAD_SPRUCE_TREE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("dead_spruce_tree");
    public static final ResourceKey<PlacedFeature> WOLFSBANE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("wolfsbane");
    public static final ResourceKey<PlacedFeature> WEREWOLF_HAVEN_TREES_PLACED = WerewolvesBiomeFeatures.createPlacedKey("heaven_trees");
    public static final ResourceKey<PlacedFeature> SILVER_ORE_PLACED = WerewolvesBiomeFeatures.createPlacedKey("silver_ore");
    public static final ResourceKey<PlacedFeature> WOLF_BERRY_BUSH_PLACED = WerewolvesBiomeFeatures.createPlacedKey("wolf_berry_bush");
    public static final ResourceKey<PlacedFeature> FOREST_ROCK_PLACED = WerewolvesBiomeFeatures.createPlacedKey("forest_rock");
    public static final ResourceKey<BiomeModifier> WEREWOLF_SPAWN = WerewolvesBiomeFeatures.createModifierKey("spawn/werewolf_spawns");
    public static final ResourceKey<BiomeModifier> HUMAN_WEREWOLF_SPAWN = WerewolvesBiomeFeatures.createModifierKey("spawn/human_werewolf_spawns");
    public static final ResourceKey<BiomeModifier> SILVER_ORE_GEN = WerewolvesBiomeFeatures.createModifierKey("gen/silver_ore");
    public static final ResourceKey<BiomeModifier> WOLFSBANE_GEN = WerewolvesBiomeFeatures.createModifierKey("gen/wolfsbane");

    public static void register(IEventBus bus) {
        INT_PROVIDER.register(bus);
    }

    public static void init() {
    }

    public static void addWerewolvesFlowers(BiomeGenerationSettings.Builder biomeGeneratorSettings) {
        biomeGeneratorSettings.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WOLFSBANE_PLACED);
    }

    public static void addWerewolfBiomeTrees(BiomeGenerationSettings.Builder biomeGeneratorSettings) {
        biomeGeneratorSettings.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WEREWOLF_HAVEN_TREES_PLACED);
    }

    public static void addWolfBerries(BiomeGenerationSettings.Builder biomeGeneratorSettings) {
        biomeGeneratorSettings.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, WOLF_BERRY_BUSH_PLACED);
    }

    public static void addForestStone(BiomeGenerationSettings.Builder biomeGeneratorSettings) {
        biomeGeneratorSettings.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, FOREST_ROCK_PLACED);
    }

    public static void createConfiguredFeatures(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        TagMatchTest stoneTest = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateTest = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        context.register(JACARANDA_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.JACARANDA_LOG.get())), (TrunkPlacer)new CherryTrunkPlacer(6, 1, 0, (IntProvider)new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)ConstantInt.of((int)1), 1).add((Object)ConstantInt.of((int)2), 1).add((Object)ConstantInt.of((int)3), 1).build()), (IntProvider)UniformInt.of((int)2, (int)4), UniformInt.of((int)-4, (int)-3), (IntProvider)UniformInt.of((int)-1, (int)0)), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.JACARANDA_LEAVES.get())), (FoliagePlacer)new CherryFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)5), 0.25f, 0.5f, 0.16666667f, 0.33333334f), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).ignoreVines().build()));
        context.register(GIANT_SPRUCE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SPRUCE_LOG), (TrunkPlacer)new StraightTrunkPlacer(8, 2, 6), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SPRUCE_LEAVES), (FoliagePlacer)new MegaPineFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0), (IntProvider)UniformInt.of((int)5, (int)17)), (FeatureSize)new TwoLayersFeatureSize(2, 1, 2)).build()));
        context.register(DEAD_SPRUCE_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SPRUCE_LOG), (TrunkPlacer)new StraightTrunkPlacer(5, 1, 3), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.AIR), (FoliagePlacer)new MegaPineFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(2, 1, 2)).build()));
        context.register(MAGIC_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((LogBlock)((Object)ModBlocks.MAGIC_LOG.get())).defaultBlockState()), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 2), (BlockStateProvider)BlockStateProvider.simple((BlockState)((LeavesBlock)((Object)ModBlocks.MAGIC_LEAVES.get())).defaultBlockState()), (FoliagePlacer)new MagicFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build()));
        context.register(WOLFSBANE, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.WOLFSBANE.get()))))));
        context.register(SILVER_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)stoneTest, (BlockState)((DropExperienceBlock)ModBlocks.SILVER_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateTest, (BlockState)((DropExperienceBlock)ModBlocks.DEEPSLATE_SILVER_ORE.get()).defaultBlockState())), 7)));
        context.register(WEREWOLF_HEAVEN_TREES, (Object)new ConfiguredFeature(Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(JACARANDA_TREE_PLACED), 0.04f), (Object)new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(MAGIC_TREE_PLACED), 0.01f), (Object)new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(DEAD_SPRUCE_TREE_PLACED), 0.3f)), (Holder)placedFeatures.getOrThrow(GIANT_SPRUCE_TREE_PLACED))));
        context.register(WOLF_BERRY_BUSH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.WOLF_BERRY_BUSH.get()).defaultBlockState().setValue((Property)WolfBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK))));
        context.register(FOREST_ROCK, (Object)new ConfiguredFeature(Feature.FOREST_ROCK, (FeatureConfiguration)new BlockStateConfiguration(Blocks.COBBLESTONE.defaultBlockState())));
    }

    public static void createPlacedFeatures(BootstapContext<PlacedFeature> context) {
        HolderGetter placedFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(WOLFSBANE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(WOLFSBANE), List.of(RarityFilter.onAverageOnceEvery((int)20), PlacementUtils.HEIGHTMAP, InSquarePlacement.spread())));
        context.register(MAGIC_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(MAGIC_TREE), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModBlocks.MAGIC_SAPLING.get())))));
        context.register(JACARANDA_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(JACARANDA_TREE), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModBlocks.JACARANDA_SAPLING.get())))));
        context.register(GIANT_SPRUCE_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(GIANT_SPRUCE_TREE), List.of(PlacementUtils.filteredByBlockSurvival((Block)Blocks.SPRUCE_SAPLING))));
        context.register(DEAD_SPRUCE_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(DEAD_SPRUCE_TREE), List.of(PlacementUtils.filteredByBlockSurvival((Block)Blocks.SPRUCE_SAPLING))));
        context.register(WEREWOLF_HAVEN_TREES_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(WEREWOLF_HEAVEN_TREES), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)15, (float)0.2f, (int)4))));
        context.register(SILVER_ORE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(SILVER_ORE), WerewolvesBiomeFeatures.commonOrePlacement(WerewolvesConfig.COMMON.silverOreWeight, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-20), (VerticalAnchor)VerticalAnchor.absolute((int)50)))));
        context.register(WOLF_BERRY_BUSH_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(WOLF_BERRY_BUSH), List.of(RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome())));
        context.register(FOREST_ROCK_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.getOrThrow(FOREST_ROCK), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
    }

    public static void createBiomeModifier(BootstapContext<BiomeModifier> context) {
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        HolderGetter placedFeatureLookup = context.lookup(Registries.PLACED_FEATURE);
        context.register(WEREWOLF_SPAWN, (Object)new ExtendedAddSpawnsBiomeModifier((HolderSet)biomeLookup.getOrThrow(ModTags.Biomes.HasSpawn.WEREWOLF), (HolderSet)biomeLookup.getOrThrow(ModTags.Biomes.NoSpawn.WEREWOLF), (List)Lists.newArrayList((Object[])new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData[]{new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.WEREWOLF_BEAST.get(), 80, 1, 2, MobCategory.MONSTER), new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.WEREWOLF_SURVIVALIST.get(), 80, 1, 2, MobCategory.MONSTER)})));
        context.register(HUMAN_WEREWOLF_SPAWN, (Object)ExtendedAddSpawnsBiomeModifier.singleSpawn((HolderSet)biomeLookup.getOrThrow(ModTags.Biomes.HasSpawn.HUMAN_WEREWOLF), (HolderSet)biomeLookup.getOrThrow(ModTags.Biomes.NoSpawn.HUMAN_WEREWOLF), (ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData)new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.HUMAN_WEREWOLF.get(), 5, 1, 1, MobCategory.MONSTER)));
        context.register(SILVER_ORE_GEN, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeLookup.getOrThrow(ModTags.Biomes.HasGen.SILVER_ORE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(SILVER_ORE_PLACED)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(WOLFSBANE_GEN, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeLookup.getOrThrow(ModTags.Biomes.HasGen.WOLFSBANE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(WOLFSBANE_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.spread(), p_195348_, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(CommonConfig.IntValueExt p_195344_, PlacementModifier p_195345_) {
        return WerewolvesBiomeFeatures.orePlacement((PlacementModifier)CountPlacement.of((IntProvider)ConfigIntProvider.of(p_195344_)), p_195345_);
    }

    private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        return WerewolvesBiomeFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)p_195350_), p_195351_);
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createConfiguredKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)new ResourceLocation("werewolves", name));
    }

    private static ResourceKey<PlacedFeature> createPlacedKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)new ResourceLocation("werewolves", name));
    }

    private static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("werewolves", name));
    }

    private static ResourceKey<StructureSet> createStructureSetKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)new ResourceLocation("werewolves", name));
    }
}

