/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.gen;

import com.mojang.serialization.Codec;
import de.teamlapen.werewolves.config.CommonConfig;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.world.gen.WerewolvesBiomeFeatures;
import java.lang.reflect.Field;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

public class ConfigIntProvider
extends IntProvider {
    public static final Codec<ConfigIntProvider> CODEC = Codec.STRING.fieldOf("configFieldName").xmap(ConfigIntProvider::new, p_236775_0_ -> p_236775_0_.supplier.getPath()).codec();
    private final CommonConfig.IntValueExt supplier;

    public static ConfigIntProvider of(CommonConfig.IntValueExt supplier) {
        return new ConfigIntProvider(supplier);
    }

    private ConfigIntProvider(String fieldName) {
        CommonConfig.IntValueExt supplier1;
        Field field = ObfuscationReflectionHelper.findField(CommonConfig.class, (String)fieldName);
        try {
            supplier1 = (CommonConfig.IntValueExt)field.get(WerewolvesConfig.COMMON);
        }
        catch (IllegalAccessException e) {
            supplier1 = null;
        }
        this.supplier = supplier1;
    }

    protected ConfigIntProvider(CommonConfig.IntValueExt supplier) {
        this.supplier = supplier;
    }

    public int sample(@NotNull RandomSource randomSource) {
        return this.supplier.get();
    }

    public int getMinValue() {
        return this.supplier.getMinValue();
    }

    public int getMaxValue() {
        return this.supplier.getMaxValue();
    }

    @NotNull
    public IntProviderType<?> getType() {
        return (IntProviderType)WerewolvesBiomeFeatures.CONFIG_INT_PROVIDER.get();
    }
}

