/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.items.oil;

import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.items.oil.WeaponOil;
import de.teamlapen.werewolves.api.items.ISilverItem;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModOils;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SilverOil
extends WeaponOil {
    public SilverOil(int color, int maxDuration) {
        super(color, maxDuration);
    }

    public float onDamage(ItemStack stack, float amount, IWeaponOil oil, LivingEntity target, LivingEntity source) {
        return Helper.isWerewolf((Entity)target) ? amount * this.getDamageModifier() : 0.0f;
    }

    public boolean canBeApplied(@NotNull ItemStack stack) {
        return super.canBeApplied(stack) && !(stack.getItem() instanceof ISilverItem) && !stack.is(ModTags.Items.SILVER_TOOL);
    }

    public float getDamageModifier() {
        return this == ModOils.SILVER_OIL_2.get() ? 0.25f : 0.125f;
    }

    public int getMaxDuration(ItemStack stack) {
        return this == ModOils.SILVER_OIL_2.get() ? (Integer)WerewolvesConfig.BALANCE.OILS.silverOil2Duration.get() : (Integer)WerewolvesConfig.BALANCE.OILS.silverOil1Duration.get();
    }

    public void getDescription(ItemStack stack, List<Component> tooltips) {
        super.getDescription(stack, tooltips);
        tooltips.add((Component)Component.translatable((String)"text.werewolves.oil.when_applied").withStyle(ChatFormatting.GRAY));
        tooltips.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"text.werewolves.oil.silver.more_damage", (Object[])new Object[]{Float.valueOf(this.getDamageModifier() * 100.0f)}).withStyle(ChatFormatting.DARK_GREEN)));
    }
}

