/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.items;

import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WerewolfToothItem
extends Item {
    public WerewolfToothItem() {
        super(new Item.Properties());
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            if (((Boolean)WerewolvesConfig.SERVER.disableToothInfection.get()).booleanValue() || ((Boolean)WerewolvesConfig.SERVER.disableWerewolfToothInfection.get()).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.deactivated_by_serveradmin"), true);
            } else {
                if (Helper.canBecomeWerewolf(player)) {
                    LupusSanguinemEffect.addSanguinemEffect((LivingEntity)player);
                    player.addEffect(new MobEffectInstance((MobEffect)ModEffects.V.POISON.get(), 60));
                } else if (Helper.isWerewolf(player)) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.werewolves.already_werewolf"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.immune_to").append((Component)Component.translatable((String)((LupusSanguinemEffect)((Object)ModEffects.LUPUS_SANGUINEM.get())).getDescriptionId())), true);
                }
                stack.shrink(1);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

