/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.effects;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.effects.WerewolfWeakeningEffect;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class SilverEffect
extends WerewolfWeakeningEffect {
    private static final String MOVEMENT_SPEED = "d28ab2de-2f21-43fe-914e-2cae40c924e4";
    private static final String ARMOR = "ff4dc3ea-68fe-4bfe-aca6-8db3cf26b285";
    private static final String DAMAGE = "67318644-855f-49ad-9c74-f310e270a7f5";

    public SilverEffect() {
        super(0xC0C0C0, List.of(new WerewolfWeakeningEffect.Modifier(Attributes.MOVEMENT_SPEED, UUID.fromString(MOVEMENT_SPEED), "Silver effect", 0.15f), new WerewolfWeakeningEffect.Modifier(Attributes.ARMOR, UUID.fromString(ARMOR), "Silver effect", 0.15f), new WerewolfWeakeningEffect.Modifier(Attributes.ATTACK_DAMAGE, UUID.fromString(DAMAGE), "Silver effect", 0.1f)));
    }

    public static MobEffectInstance createSilverEffect(LivingEntity entity, int defaultDuration, int amplifier) {
        return SilverEffect.createSilverEffect(entity, defaultDuration, amplifier, false);
    }

    public static MobEffectInstance createSilverEffect(LivingEntity entity, int defaultDuration, int amplifier, boolean isContinued) {
        if (entity instanceof Player && Helper.isWerewolf((Player)entity) && WerewolfPlayer.getOpt((Player)entity).filter(s -> s.getForm().isHumanLike()).map(w -> w.getSkillHandler().isSkillEnabled((ISkill)ModSkills.SILVER_BLOODED.get())).orElse(false).booleanValue()) {
            if (amplifier > 0) {
                --amplifier;
            } else if (!isContinued) {
                defaultDuration /= 2;
            }
        }
        return new MobEffectInstance((MobEffect)ModEffects.SILVER.get(), defaultDuration, amplifier, isContinued, true);
    }
}

