/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.effects;

import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.effects.WerewolvesEffect;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class HowlingEffect
extends WerewolvesEffect {
    public static final String ATTACK_SPEED = "193a0552-7368-4759-8020-3285caaf12f6";

    public HowlingEffect() {
        super(MobEffectCategory.BENEFICIAL, 16763150);
        this.addAttributeModifier(Attributes.ATTACK_SPEED, ATTACK_SPEED, 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public boolean isDurationEffectTick(int duration, int amplifier) {
        return duration == (Integer)WerewolvesConfig.BALANCE.SKILLS.howling_disabled_duration.get() * 20;
    }

    public void applyEffectTick(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        this.removeAttributeModifiers(entityLivingBaseIn, entityLivingBaseIn.getAttributes(), amplifier);
    }

    public void removeAttributeModifiers(@Nonnull LivingEntity entityLivingBaseIn, @Nonnull AttributeMap attributeMapIn, int amplifier) {
        if (Helper.isWerewolf((Entity)entityLivingBaseIn)) {
            super.removeAttributeModifiers(entityLivingBaseIn, attributeMapIn, amplifier);
        }
    }

    public void addAttributeModifiers(@Nonnull LivingEntity entityLivingBaseIn, @Nonnull AttributeMap attributeMapIn, int amplifier) {
        if (Helper.isWerewolf((Entity)entityLivingBaseIn)) {
            super.addAttributeModifiers(entityLivingBaseIn, attributeMapIn, amplifier);
        }
    }
}

