/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves;

import com.mojang.brigadier.CommandDispatcher;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.werewolves.GeneralEventHandler;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.client.core.ClientRegistryHandler;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModCommands;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModLootTables;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.core.RegistryManager;
import de.teamlapen.werewolves.entities.ModEntityEventHandler;
import de.teamlapen.werewolves.entities.player.ModPlayerEventHandler;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.items.WerewolfRefinementItem;
import de.teamlapen.werewolves.modcompat.guide.WerewolvesGuideBook;
import de.teamlapen.werewolves.modcompat.terrablender.TerraBlenderCompat;
import de.teamlapen.werewolves.network.ModPacketDispatcher;
import de.teamlapen.werewolves.proxy.ClientProxy;
import de.teamlapen.werewolves.proxy.Proxy;
import de.teamlapen.werewolves.proxy.ServerProxy;
import de.teamlapen.werewolves.util.LordTitles;
import de.teamlapen.werewolves.util.Permissions;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WUtils;
import de.teamlapen.werewolves.util.WerewolfVillageData;
import de.teamlapen.werewolves.world.gen.OverworldModifications;
import de.teamlapen.werewolves.world.gen.WerewolvesBiomeFeatures;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="werewolves")
public class WerewolvesMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final AbstractPacketDispatcher dispatcher = new ModPacketDispatcher();
    public static final Proxy proxy = (Proxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final MobCategory WEREWOLF_CREATURE_TYPE = MobCategory.create((String)"werewolves_werewolf", (String)"werewolves_werewolf", (int)8, (boolean)false, (boolean)false, (int)128);
    private static final MobType WEREWOLF_CREATURE_ATTRIBUTES = new MobType();
    public static WerewolvesMod instance;
    public final RegistryManager registryManager = new RegistryManager();
    private boolean setupAPI;

    public WerewolvesMod() {
        instance = this;
        WUtils.init();
        Optional opt = ModList.get().getModContainerById("vampirism");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::loadComplete);
        bus.addListener(this::processIMC);
        bus.addListener(this::enqueueIMC);
        bus.addListener(this::setUpClient);
        bus.addListener(this::blockRegister);
        bus.register((Object)this.registryManager);
        bus.addListener(this::registerCapability);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientRegistryHandler::init);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.addListener(ModLootTables::onLootLoad);
        MinecraftForge.EVENT_BUS.register(Permissions.class);
        if (ModList.get().isLoaded("guideapi_vp")) {
            MinecraftForge.EVENT_BUS.addListener(WerewolvesGuideBook::onVampirismGuideBookCategoriesEvent);
        }
        RegistryManager.setupRegistries(FMLJavaModLoadingContext.get().getModEventBus());
        WerewolvesBiomeFeatures.register(FMLJavaModLoadingContext.get().getModEventBus());
        bus.addListener(ModItems::registerOtherCreativeTabItems);
        WerewolvesConfig.registerConfigs();
    }

    private void setupAPI() {
        if (!this.setupAPI) {
            WReference.WEREWOLF_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.WEREWOLF_PLAYER_KEY, IWerewolfPlayer.class, () -> WerewolfPlayer.CAP).color(Color.orange.getRGB()).hostileTowardsNeutral().highestLevel(14).lord().lordLevel(5).lordTitle(LordTitles::getWerewolfTitle).enableLordSkills().build().village(WerewolfVillageData::werewolfVillage).chatColor(ChatFormatting.GOLD).name("text.werewolves.werewolf").namePlural("text.vampirism.werewolves").refinementItems(WerewolfRefinementItem::getRefinementItem).addTag(Registries.BIOME, ModTags.Biomes.IS_WEREWOLF_BIOME).addTag(Registries.POINT_OF_INTEREST_TYPE, ModTags.PoiTypes.IS_WEREWOLF).addTag(Registries.VILLAGER_PROFESSION, ModTags.Professions.IS_WEREWOLF).addTag(Registries.ENTITY_TYPE, ModTags.Entities.WEREWOLF).addTag(VampirismRegistries.TASK_ID, ModTags.Tasks.IS_WEREWOLF).register();
            WReference.WEREWOLF_CREATURE_ATTRIBUTES = WEREWOLF_CREATURE_ATTRIBUTES;
            this.setupAPI = true;
        }
    }

    private void blockRegister(RegisterEvent event) {
        this.setupAPI();
    }

    private void setup(@NotNull FMLCommonSetupEvent event) {
        this.setupAPI();
        dispatcher.registerPackets();
        this.registryManager.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        MinecraftForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GeneralEventHandler());
        event.enqueueWork(TerraBlenderCompat::registerBiomeProviderIfPresentUnsafe);
    }

    private void loadComplete(@NotNull FMLLoadCompleteEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        event.enqueueWork(OverworldModifications::addBiomesToOverworldUnsafe);
    }

    private void processIMC(@NotNull InterModProcessEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        HelperRegistry.registerPlayerEventReceivingCapability(WerewolfPlayer.CAP, WerewolfPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(WerewolfPlayer.CAP, (ResourceLocation)REFERENCE.WEREWOLF_PLAYER_KEY, WerewolfPlayer.class);
    }

    private void registerCapability(@NotNull RegisterCapabilitiesEvent event) {
        event.register(IWerewolfPlayer.class);
    }

    private void setUpClient(FMLClientSetupEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void onCommandsRegister(@NotNull RegisterCommandsEvent event) {
        ModCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

