/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record ServerboundBiteEventPackage(int entityId) implements IMessage.IServerBoundMessage
{
    static void encode(ServerboundBiteEventPackage msg, FriendlyByteBuf buf) {
        buf.writeVarInt(msg.entityId);
    }

    static ServerboundBiteEventPackage decode(FriendlyByteBuf buf) {
        int entityId = buf.readVarInt();
        return new ServerboundBiteEventPackage(entityId);
    }

    public static void handle(ServerboundBiteEventPackage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            if (ctx.getSender() != null) {
                WerewolfPlayer.getOpt((Player)ctx.getSender()).ifPresent(werewolfPlayer -> werewolfPlayer.bite(msg.entityId));
            }
            ctx.setPacketHandled(true);
        });
    }
}

