/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.werewolves.blocks.DaffodilBlock;
import de.teamlapen.werewolves.blocks.LeavesBlock;
import de.teamlapen.werewolves.blocks.LogBlock;
import de.teamlapen.werewolves.blocks.StoneAltarBlock;
import de.teamlapen.werewolves.blocks.StoneAltarFireBowlBlock;
import de.teamlapen.werewolves.blocks.StrippableLogBlock;
import de.teamlapen.werewolves.blocks.WolfBerryBushBlock;
import de.teamlapen.werewolves.blocks.WolfsbaneBlock;
import de.teamlapen.werewolves.blocks.WolfsbaneDiffuserBlock;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.world.tree.JacarandaTree;
import de.teamlapen.werewolves.world.tree.MagicTree;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"werewolves");
    public static final RegistryObject<DropExperienceBlock> SILVER_ORE = ModBlocks.registerWithItem("silver_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f, 5.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<DropExperienceBlock> DEEPSLATE_SILVER_ORE = ModBlocks.registerWithItem("deepslate_silver_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE)));
    public static final RegistryObject<WolfsbaneBlock> WOLFSBANE = ModBlocks.registerWithItem("wolfsbane", WolfsbaneBlock::new);
    public static final RegistryObject<Block> SILVER_BLOCK = ModBlocks.registerWithItem("silver_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL)));
    public static final RegistryObject<Block> RAW_SILVER_BLOCK = ModBlocks.registerWithItem("raw_silver_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.RAW_IRON).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final RegistryObject<FlowerPotBlock> POTTED_WOLFSBANE = BLOCKS.register("potted_wolfsbane", () -> {
        FlowerPotBlock pot = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, WOLFSBANE, BlockBehaviour.Properties.of().noCollission().pushReaction(PushReaction.DESTROY).instabreak().noOcclusion().strength(0.0f));
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(WOLFSBANE.getId(), () -> pot);
        return pot;
    });
    public static final RegistryObject<TotemTopBlock> TOTEM_TOP_WEREWOLVES_WEREWOLF = BLOCKS.register("totem_top_werewolves_werewolf", () -> new TotemTopBlock(false, REFERENCE.WEREWOLF_PLAYER_KEY));
    public static final RegistryObject<TotemTopBlock> TOTEM_TOP_WEREWOLVES_WEREWOLF_CRAFTED = BLOCKS.register("totem_top_werewolves_werewolf_crafted", () -> new TotemTopBlock(true, REFERENCE.WEREWOLF_PLAYER_KEY));
    public static final RegistryObject<StoneAltarBlock> STONE_ALTAR = ModBlocks.registerWithItem("stone_altar", StoneAltarBlock::new);
    public static final RegistryObject<StoneAltarFireBowlBlock> STONE_ALTAR_FIRE_BOWL = ModBlocks.registerWithItem("stone_altar_fire_bowl", StoneAltarFireBowlBlock::new);
    public static final RegistryObject<Block> DAFFODIL = ModBlocks.registerWithItem("daffodil", DaffodilBlock::new);
    public static final RegistryObject<Block> POTTED_DAFFODIL = BLOCKS.register("potted_daffodil", () -> {
        FlowerPotBlock pot = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, DAFFODIL, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instabreak().noOcclusion());
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(DAFFODIL.getId(), () -> pot);
        return pot;
    });
    public static final RegistryObject<Block> WOLF_BERRY_BUSH = BLOCKS.register("wolf_berry_bush", () -> new WolfBerryBushBlock(BlockBehaviour.Properties.of().isViewBlocking(UtilLib::never).pushReaction(PushReaction.DESTROY).randomTicks().noCollission().sound(SoundType.SWEET_BERRY_BUSH)));
    public static final RegistryObject<LeavesBlock> JACARANDA_LEAVES = ModBlocks.registerWithItem("jacaranda_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).isViewBlocking(UtilLib::never).ignitedByLava().strength(0.2f).pushReaction(PushReaction.DESTROY).randomTicks().sound(SoundType.GRASS).noOcclusion()));
    public static final RegistryObject<LeavesBlock> MAGIC_LEAVES = ModBlocks.registerWithItem("magic_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.of().isViewBlocking(UtilLib::never).mapColor(MapColor.COLOR_LIGHT_BLUE).ignitedByLava().strength(0.2f).pushReaction(PushReaction.DESTROY).randomTicks().sound(SoundType.GRASS).noOcclusion()));
    public static final RegistryObject<Block> JACARANDA_PLANKS = ModBlocks.registerWithItem("jacaranda_planks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final RegistryObject<Block> MAGIC_PLANKS = ModBlocks.registerWithItem("magic_planks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).ignitedByLava().strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final RegistryObject<LogBlock> STRIPPED_JACARANDA_LOG = ModBlocks.registerWithItem("stripped_jacaranda_log", () -> new LogBlock(MapColor.COLOR_BLACK, MapColor.COLOR_PINK));
    public static final RegistryObject<LogBlock> STRIPPED_MAGIC_LOG = ModBlocks.registerWithItem("stripped_magic_log", () -> new LogBlock(MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_LIGHT_BLUE));
    public static final RegistryObject<LogBlock> JACARANDA_LOG = ModBlocks.registerWithItem("jacaranda_log", () -> new StrippableLogBlock(MapColor.COLOR_PINK, MapColor.COLOR_PINK, (Supplier<? extends LogBlock>)STRIPPED_JACARANDA_LOG));
    public static final RegistryObject<LogBlock> MAGIC_LOG = ModBlocks.registerWithItem("magic_log", () -> new StrippableLogBlock(MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_LIGHT_BLUE, (Supplier<? extends LogBlock>)STRIPPED_MAGIC_LOG));
    public static final RegistryObject<SaplingBlock> JACARANDA_SAPLING = ModBlocks.registerWithItem("jacaranda_sapling", () -> new SaplingBlock((AbstractTreeGrower)new JacarandaTree(), BlockBehaviour.Properties.of().isViewBlocking(UtilLib::never).ignitedByLava().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_PINK).noCollission().randomTicks().instabreak().sound(SoundType.GRASS)));
    public static final RegistryObject<SaplingBlock> MAGIC_SAPLING = ModBlocks.registerWithItem("magic_sapling", () -> new SaplingBlock((AbstractTreeGrower)new MagicTree(), BlockBehaviour.Properties.of().isViewBlocking(UtilLib::never).ignitedByLava().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_LIGHT_BLUE).noCollission().randomTicks().instabreak().sound(SoundType.GRASS)));
    public static final RegistryObject<DoorBlock> JACARANDA_DOOR = ModBlocks.registerWithItem("jacaranda_door", () -> new DoorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().strength(3.0f).sound(SoundType.WOOD).noOcclusion(), LogBlock.JACARANDA_BLOCK_TYPE));
    public static final RegistryObject<DoorBlock> MAGIC_DOOR = ModBlocks.registerWithItem("magic_door", () -> new DoorBlock(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_LIGHT_BLUE).strength(3.0f).sound(SoundType.WOOD).noOcclusion(), LogBlock.MAGIC_BLOCK_TYPE));
    public static final RegistryObject<TrapDoorBlock> JACARANDA_TRAPDOOR = ModBlocks.registerWithItem("jacaranda_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_PINK).strength(3.0f).sound(SoundType.WOOD).noOcclusion().isValidSpawn(ModBlocks::never), LogBlock.JACARANDA_BLOCK_TYPE));
    public static final RegistryObject<TrapDoorBlock> MAGIC_TRAPDOOR = ModBlocks.registerWithItem("magic_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_LIGHT_BLUE).strength(3.0f).sound(SoundType.WOOD).noOcclusion().isValidSpawn(ModBlocks::never), LogBlock.MAGIC_BLOCK_TYPE));
    public static final RegistryObject<StairBlock> JACARANDA_STAIRS = ModBlocks.registerWithItem("jacaranda_stairs", () -> new StairBlock(() -> ((Block)JACARANDA_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.copy((BlockBehaviour)((BlockBehaviour)JACARANDA_PLANKS.get()))));
    public static final RegistryObject<StairBlock> MAGIC_STAIRS = ModBlocks.registerWithItem("magic_stairs", () -> new StairBlock(() -> ((Block)MAGIC_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.copy((BlockBehaviour)((BlockBehaviour)MAGIC_PLANKS.get()))));
    public static final RegistryObject<LogBlock> STRIPPED_JACARANDA_WOOD = ModBlocks.registerWithItem("stripped_jacaranda_wood", () -> new LogBlock(MapColor.COLOR_PINK, MapColor.COLOR_PINK));
    public static final RegistryObject<LogBlock> STRIPPED_MAGIC_WOOD = ModBlocks.registerWithItem("stripped_magic_wood", () -> new LogBlock(MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_LIGHT_BLUE));
    public static final RegistryObject<LogBlock> JACARANDA_WOOD = ModBlocks.registerWithItem("jacaranda_wood", () -> new StrippableLogBlock(MapColor.COLOR_PINK, MapColor.COLOR_PINK, (Supplier<? extends LogBlock>)STRIPPED_JACARANDA_WOOD));
    public static final RegistryObject<LogBlock> MAGIC_WOOD = ModBlocks.registerWithItem("magic_wood", () -> new StrippableLogBlock(MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_LIGHT_BLUE, (Supplier<? extends LogBlock>)STRIPPED_MAGIC_WOOD));
    public static final RegistryObject<StandingSignBlock> JACARANDA_SIGN = BLOCKS.register("jacaranda_sign", () -> new StandingSignBlock(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_PINK).noCollission().strength(1.0f).sound(SoundType.WOOD), LogBlock.JACARANDA));
    public static final RegistryObject<StandingSignBlock> MAGIC_SIGN = BLOCKS.register("magic_sign", () -> new StandingSignBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).ignitedByLava().noCollission().strength(1.0f).sound(SoundType.WOOD), LogBlock.MAGIC));
    public static final RegistryObject<WallSignBlock> JACARANDA_WALL_SIGN = BLOCKS.register("jacaranda_wall_sign", () -> new WallSignBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().noCollission().strength(1.0f).sound(SoundType.WOOD).lootFrom(JACARANDA_SIGN), LogBlock.JACARANDA));
    public static final RegistryObject<WallSignBlock> MAGIC_WALL_SIGN = BLOCKS.register("magic_wall_sign", () -> new WallSignBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).ignitedByLava().noCollission().strength(1.0f).sound(SoundType.WOOD).lootFrom(MAGIC_SIGN), LogBlock.MAGIC));
    public static final RegistryObject<PressurePlateBlock> JACARANDA_PRESSURE_PLATE = ModBlocks.registerWithItem("jacaranda_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_PINK).noCollission().strength(0.5f).sound(SoundType.WOOD), LogBlock.JACARANDA_BLOCK_TYPE));
    public static final RegistryObject<PressurePlateBlock> MAGIC_PRESSURE_PLATE = ModBlocks.registerWithItem("magic_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_LIGHT_BLUE).noCollission().strength(0.5f).sound(SoundType.WOOD), LogBlock.MAGIC_BLOCK_TYPE));
    public static final RegistryObject<ButtonBlock> JACARANDA_BUTTON = ModBlocks.registerWithItem("jacaranda_button", () -> new ButtonBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).isViewBlocking(UtilLib::never).noCollission().strength(0.5f).sound(SoundType.WOOD), LogBlock.JACARANDA_BLOCK_TYPE, 30, true));
    public static final RegistryObject<ButtonBlock> MAGIC_BUTTON = ModBlocks.registerWithItem("magic_button", () -> new ButtonBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).isViewBlocking(UtilLib::never).noCollission().noOcclusion().isValidSpawn(ModBlocks::never).strength(0.5f).sound(SoundType.WOOD), LogBlock.MAGIC_BLOCK_TYPE, 30, true));
    public static final RegistryObject<SlabBlock> JACARANDA_SLAB = ModBlocks.registerWithItem("jacaranda_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final RegistryObject<SlabBlock> MAGIC_SLAB = ModBlocks.registerWithItem("magic_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).ignitedByLava().strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final RegistryObject<FenceGateBlock> JACARANDA_FENCE_GATE = ModBlocks.registerWithItem("jacaranda_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().strength(2.0f, 3.0f).sound(SoundType.WOOD), SoundEvents.FENCE_GATE_CLOSE, SoundEvents.FENCE_GATE_OPEN));
    public static final RegistryObject<FenceGateBlock> MAGIC_FENCE_GATE = ModBlocks.registerWithItem("magic_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).ignitedByLava().strength(2.0f, 3.0f).sound(SoundType.WOOD), SoundEvents.FENCE_GATE_CLOSE, SoundEvents.FENCE_GATE_OPEN));
    public static final RegistryObject<FenceBlock> JACARANDA_FENCE = ModBlocks.registerWithItem("jacaranda_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final RegistryObject<FenceBlock> MAGIC_FENCE = ModBlocks.registerWithItem("magic_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).ignitedByLava().strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final RegistryObject<WolfsbaneDiffuserBlock> WOLFSBANE_DIFFUSER = ModBlocks.registerWithItem("wolfsbane_diffuser_normal", () -> new WolfsbaneDiffuserBlock(WolfsbaneDiffuserBlock.Type.NORMAL));
    public static final RegistryObject<WolfsbaneDiffuserBlock> WOLFSBANE_DIFFUSER_LONG = ModBlocks.registerWithItem("wolfsbane_diffuser_long", () -> new WolfsbaneDiffuserBlock(WolfsbaneDiffuserBlock.Type.LONG));
    public static final RegistryObject<WolfsbaneDiffuserBlock> WOLFSBANE_DIFFUSER_IMPROVED = ModBlocks.registerWithItem("wolfsbane_diffuser_improved", () -> new WolfsbaneDiffuserBlock(WolfsbaneDiffuserBlock.Type.IMPROVED));

    static void register(IEventBus bus) {
        BLOCKS.register(bus);
    }

    private static <T extends Block> RegistryObject<T> registerWithItem(String name, Supplier<T> supplier) {
        return ModBlocks.registerWithItem(name, supplier, new Item.Properties());
    }

    private static <T extends Block> RegistryObject<T> registerWithItem(String name, Supplier<T> supplier, Item.Properties properties) {
        RegistryObject block = BLOCKS.register(name, supplier);
        ModItems.register(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }

    public static Set<Block> getAllBlocks() {
        return BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toSet());
    }

    private static boolean never(BlockState pState, BlockGetter pLevel, BlockPos pPos, EntityType<?> pValue) {
        return false;
    }

    static {
        V.init();
    }

    public static class V {
        public static final RegistryObject<Block> MED_CHAIR = RegistryObject.create((ResourceLocation)new ResourceLocation("vampirism", "med_chair"), (ResourceKey)ForgeRegistries.Keys.BLOCKS, (String)"werewolves");

        private static void init() {
        }
    }
}

