/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import de.cheaterpaul.fallingleaves.FallingLeavesMod;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.data.LeafSettingLoader;
import de.cheaterpaul.fallingleaves.data.LeafTypeLoader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;

@EventBusSubscriber(modid="fallingleaves", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class LeafLoader {
    public static final ResourceLocation LEAF_TYPE_LISTENER = ResourceLocation.fromNamespaceAndPath((String)"fallingleaves", (String)"leaf_type");
    public static final ResourceLocation TREE_VALUELISTENER = ResourceLocation.fromNamespaceAndPath((String)"fallingleaves", (String)"tree_value");
    private static LeafTypeLoader leafTypeLoader;
    private static LeafSettingLoader treeValueLoader;
    private static final Map<LeafTypeLoader.LeafType, LeafTypeLoader.ParticleProvider> SNOW_CACHE;

    @SubscribeEvent
    public static void registerReloadListeners(AddClientReloadListenersEvent event) {
        leafTypeLoader = new LeafTypeLoader(Minecraft.getInstance().getTextureManager());
        event.addListener(LEAF_TYPE_LISTENER, (PreparableReloadListener)leafTypeLoader);
        treeValueLoader = new LeafSettingLoader();
        event.addListener(TREE_VALUELISTENER, (PreparableReloadListener)treeValueLoader);
    }

    @SubscribeEvent
    public static void onReload(TextureAtlasStitchedEvent event) {
        SNOW_CACHE.clear();
    }

    public static LeafTypeLoader.LeafTypeSettings getSpriteForLeafType(ResourceLocation leafType) {
        return leafTypeLoader.getSpriteSet(leafType);
    }

    public static LeafTypeLoader.ParticleProvider getSnowParticleProvider(final LeafTypeLoader.LeafTypeSettings settings) {
        return SNOW_CACHE.computeIfAbsent(settings.getLeafType(), type -> {
            final LeafTypeLoader.LeafTypeSettings snowSetting = LeafLoader.getSpriteForLeafType(FallingLeavesMod.SNOW);
            return new LeafTypeLoader.ParticleProvider(){

                @Override
                public ParticleEngine.MutableSpriteSet getSpriteSet() {
                    return snowSetting.getSpriteSet();
                }

                @Override
                public float sizeModifier() {
                    return snowSetting.sizeModifier() * settings.snowSizeModifier();
                }

                @Override
                public float lifeSpawnModifier() {
                    return snowSetting.lifeSpawnModifier();
                }
            };
        });
    }

    public static LeafSettingsEntry getLeafSetting(ResourceLocation location) {
        return treeValueLoader.getLeafSetting(location);
    }

    static {
        SNOW_CACHE = new HashMap<LeafTypeLoader.LeafType, LeafTypeLoader.ParticleProvider>();
    }
}

