/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves;

import de.cheaterpaul.fallingleaves.FallingLeavesMod;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.data.LeafLoader;
import de.cheaterpaul.fallingleaves.modcompat.SereneSeasons;
import de.cheaterpaul.fallingleaves.util.LeafUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="fallingleaves", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class EventHandler {
    @SubscribeEvent
    public static void onAttackLeavesBlock(PlayerInteractEvent.LeftClickBlock e) {
        BlockState state;
        ResourceLocation location;
        LeafSettingsEntry leafSettings;
        if (e.getLevel().isClientSide && ((leafSettings = LeafLoader.getLeafSetting(location = BuiltInRegistries.BLOCK.getKey((Object)(state = e.getLevel().getBlockState(e.getPos())).getBlock()))) != null || state.getBlock() instanceof LeavesBlock)) {
            for (int i = 0; i < 3; ++i) {
                if (!e.getEntity().getRandom().nextBoolean()) continue;
                LeafUtil.trySpawnLeafParticle(state, (ClientLevel)e.getLevel(), e.getPos(), e.getEntity().getRandom(), leafSettings);
            }
        }
    }

    public static void spawnParticles(BlockState state, ClientLevel level, BlockPos pos, RandomSource random) {
        ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        LeafSettingsEntry leafSettings = LeafLoader.getLeafSetting(location);
        if (leafSettings == null && !(state.getBlock() instanceof LeavesBlock)) {
            return;
        }
        if (!((Boolean)FallingLeavesMod.CONFIG.dropFromPlayerPlacedBlocks.get()).booleanValue() && ((Boolean)state.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue()) {
            return;
        }
        EventHandler.spawnLeaves(state, level, pos, random, leafSettings);
        EventHandler.spawnSnow(state, level, pos, random, leafSettings);
    }

    public static void spawnLeaves(BlockState state, ClientLevel level, BlockPos pos, RandomSource random, LeafSettingsEntry leafSettings) {
        double spawnChance = 1.0;
        double modifier = ((Integer)FallingLeavesMod.CONFIG.leafSpawnRate.get()).intValue();
        if (leafSettings != null) {
            spawnChance = leafSettings.spawnRateFactor();
            if (leafSettings.considerAsConifer()) {
                modifier = ((Integer)FallingLeavesMod.CONFIG.coniferLeafSpawnRate.get()).intValue();
            }
        }
        modifier = modifier / 10.0 / 75.0;
        spawnChance *= modifier;
        spawnChance *= (double)SereneSeasons.getModifier((Level)level);
        while (spawnChance > 0.0) {
            if (random.nextDouble() < spawnChance) {
                LeafUtil.trySpawnLeafParticle(state, level, pos, random, leafSettings);
            }
            spawnChance -= 1.0;
        }
    }

    public static void spawnSnow(BlockState state, ClientLevel level, BlockPos pos, RandomSource random, LeafSettingsEntry leafSettings) {
        if (EventHandler.canSnow(level, pos)) {
            double spawnChance = 1.0;
            double modifier = ((Integer)FallingLeavesMod.CONFIG.snowSpawnRate.get()).intValue();
            modifier = modifier / 10.0 / 75.0;
            spawnChance *= modifier;
            if (level.isRaining() && ((Biome)level.getBiome(pos).value()).getPrecipitationAt(pos, level.getSeaLevel()) == Biome.Precipitation.SNOW) {
                spawnChance *= 5.0;
            }
            while (spawnChance > 0.0) {
                if (random.nextDouble() < spawnChance) {
                    LeafUtil.trySpawnSnowParticle(state, level, pos, random, leafSettings);
                }
                spawnChance -= 1.0;
            }
        }
    }

    private static boolean canSnow(ClientLevel level, BlockPos leavesPos) {
        if (((Boolean)FallingLeavesMod.CONFIG.disableSnow.get()).booleanValue()) {
            return false;
        }
        BlockPos.MutableBlockPos pos = leavesPos.mutable();
        for (int distance = 0; distance < 5; ++distance) {
            pos.move(Direction.UP);
            BlockState blockState = level.getBlockState((BlockPos)pos);
            if (blockState.is(BlockTags.SNOW)) {
                return true;
            }
            if (LeavesBlock.isShapeFullBlock((VoxelShape)blockState.getShape((BlockGetter)level, (BlockPos)pos))) continue;
            return false;
        }
        return false;
    }

    public static void spawnDecayingParticles(BlockState state, ClientLevel level, BlockPos pos, RandomSource random) {
        int i;
        ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        LeafSettingsEntry leafSettings = LeafLoader.getLeafSetting(location);
        if (leafSettings == null && !(state.getBlock() instanceof LeavesBlock)) {
            return;
        }
        if (!((Boolean)FallingLeavesMod.CONFIG.dropFromPlayerPlacedBlocks.get()).booleanValue() && ((Boolean)state.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue()) {
            return;
        }
        for (i = 0; i < (Integer)FallingLeavesMod.CONFIG.maxDecayingLeaves.get(); ++i) {
            if (!random.nextBoolean()) continue;
            LeafUtil.trySpawnLeafParticle(state, level, pos, random, leafSettings);
        }
        for (i = 0; i < (Integer)FallingLeavesMod.CONFIG.maxDecayingSnowParticles.get(); ++i) {
            if (!random.nextBoolean()) continue;
            LeafUtil.trySpawnSnowParticle(state, level, pos, random, leafSettings);
        }
    }
}

