/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.modcompat;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SereneSeasonsConfig {
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> seasonFallRate;
    private Map<Enum<?>, Float> enabledSeasons = new HashMap();

    public SereneSeasonsConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Serene Seasons");
        this.seasonFallRate = builder.comment(new String[]{"spawnrate modifier per season/subseason", "Format: '<season>:<modifier>'; eg 'SUMMER:0.23'", "Subseasons override seasons", "Allowed seasons: " + Stream.concat(Arrays.stream(Season.values()), Arrays.stream(Season.SubSeason.values())).map(Enum::name).collect(Collectors.joining(","))}).defineList("seasonFallRate", this.defaults(), string -> string instanceof String && this.exists((String)string));
        builder.pop();
    }

    public void updateCache() {
        this.enabledSeasons = ((List)this.seasonFallRate.get()).stream().map(this::create).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public float getModifier(Level level) {
        ISeasonState state = SeasonHelper.getSeasonState((Level)level);
        return (this.enabledSeasons.containsKey(state.getSubSeason()) ? this.enabledSeasons.get(state.getSubSeason()) : this.enabledSeasons.getOrDefault(state.getSeason(), Float.valueOf(1.0f))).floatValue();
    }

    private List<? extends String> defaults() {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Season.SPRING, (Object)0), Pair.of((Object)Season.AUTUMN, (Object)1), Pair.of((Object)Season.SUMMER, (Object)0.2), Pair.of((Object)Season.WINTER, (Object)0.2)}).stream().map(p -> ((Season)p.getKey()).name() + ":" + String.valueOf(p.getValue())).collect(Collectors.toList());
    }

    public boolean exists(String string) {
        try {
            this.create(string);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public Pair<Enum<?>, Float> create(String string) {
        Season season;
        String[] split = string.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid format");
        }
        float modifier = Float.parseFloat(split[1]);
        try {
            season = Season.valueOf((String)split[0]);
        }
        catch (IllegalArgumentException e) {
            try {
                season = Season.SubSeason.valueOf((String)split[0]);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("Season could not be found");
            }
        }
        return Pair.of((Object)season, (Object)Float.valueOf(modifier));
    }
}

