/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.init;

import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.data.LeafSettingGenerator;
import de.cheaterpaul.fallingleaves.data.LeafSettingLoader;
import de.cheaterpaul.fallingleaves.data.LeafTypeLoader;
import de.cheaterpaul.fallingleaves.init.EventHandler;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.modcompat.SereneSeasons;
import de.cheaterpaul.fallingleaves.util.TextureCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ClientMod {
    public static final ResourceLocation DEFAULT = ResourceLocation.fromNamespaceAndPath((String)"fallingleaves", (String)"default");
    public static final ResourceLocation CONIFER = ResourceLocation.fromNamespaceAndPath((String)"fallingleaves", (String)"conifer");
    private static LeafTypeLoader leafTypeLoader;
    private static LeafSettingLoader treeValueLoader;

    public static SpriteSet getSpriteForLeafType(ResourceLocation leafType) {
        return leafTypeLoader.getSpriteSet(leafType);
    }

    public static LeafSettingsEntry getLeafSetting(ResourceLocation location) {
        return treeValueLoader.getLeafSetting(location);
    }

    private static void gatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeClient(), (DataProvider)new LeafSettingGenerator(event.getGenerator().getPackOutput()));
    }

    public static void setupClient(IEventBus modBus) {
        modBus.addListener(ClientMod::gatherData);
        modBus.addListener(ClientMod::registerReloadListeners);
        modBus.addListener(ClientMod::registerReloadListeners);
        modBus.addListener(ClientMod::onReload);
        if (SereneSeasons.setup()) {
            modBus.register(SereneSeasons.class);
        }
        FallingLeavesConfig.registerConfigs();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        leafTypeLoader = new LeafTypeLoader(Minecraft.getInstance().getTextureManager());
        event.registerReloadListener((PreparableReloadListener)leafTypeLoader);
        treeValueLoader = new LeafSettingLoader();
        event.registerReloadListener((PreparableReloadListener)treeValueLoader);
    }

    public static void onReload(TextureStitchEvent.Post event) {
        TextureCache.INST.clear();
    }
}

