/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.cheaterpaul.fallingleaves.data.LeafTypeLoader;
import de.cheaterpaul.fallingleaves.init.ClientMod;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.util.Wind;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeafParticle
extends TextureSheetParticle {
    public static final ParticleRenderType LEAVES_SHEET = new ParticleRenderType(){

        @NotNull
        public BufferBuilder begin(Tesselator tesselator, @NotNull TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)LeafTypeLoader.LEAVES_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "FALLINGLEAVES_PARTICLE_SHEET_TRANSLUCENT";
        }
    };
    protected static final float TAU = (float)Math.PI * 2;
    protected static final int FADE_DURATION = 16;
    protected static final double WATER_FRICTION = 0.05;
    protected final float windCoefficient;
    protected final float maxRotateSpeed;
    protected final int maxRotateTime;
    protected int rotateTime = 0;

    protected FallingLeafParticle(ClientLevel clientWorld, double x, double y, double z, double r, double g, double b, SpriteSet provider) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.pickSprite(provider);
        this.gravity = 0.08f + this.random.nextFloat() * 0.04f;
        this.windCoefficient = 0.6f + this.random.nextFloat() * 0.4f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.hasPhysics = true;
        this.lifetime = (Integer)FallingLeavesConfig.CONFIG.leafLifespan.get();
        this.rCol = (float)r;
        this.gCol = (float)g;
        this.bCol = (float)b;
        this.maxRotateTime = (3 + this.random.nextInt(5)) * 20;
        this.maxRotateSpeed = (float)(this.random.nextBoolean() ? -1 : 1) * (0.1f + 2.4f * this.random.nextFloat()) * ((float)Math.PI * 2) / 20.0f;
        this.roll = this.oRoll = this.random.nextFloat() * ((float)Math.PI * 2);
        this.quadSize = (float)((Integer)FallingLeavesConfig.CONFIG.leafSize.get()).intValue() / 50.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.oRoll = this.roll;
        ++this.age;
        if (this.age >= this.lifetime + 1 - 16) {
            this.alpha -= 0.0625f;
        }
        if (this.age >= this.lifetime) {
            this.remove();
            return;
        }
        if (this.level.getFluidState(new BlockPos((int)this.x, (int)this.y, (int)this.z)).is(FluidTags.WATER)) {
            this.yd = 0.0;
            this.rotateTime = 0;
            this.xd *= 0.95;
            this.zd *= 0.95;
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            if (!this.onGround) {
                this.rotateTime = Math.min(this.rotateTime + 1, this.maxRotateTime);
                this.roll += (float)this.rotateTime / (float)this.maxRotateTime * this.maxRotateSpeed;
            } else {
                this.rotateTime = 0;
            }
            this.xd += ((double)Wind.windX - this.xd) * (double)this.windCoefficient / 60.0;
            this.zd += ((double)Wind.windZ - this.zd) * (double)this.windCoefficient / 60.0;
        }
        this.move(this.xd, this.yd, this.zd);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return LEAVES_SHEET;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeavesParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(@Nullable SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double r, double g, double b) {
            return new FallingLeafParticle(world, x, y, z, r, g, b, ClientMod.getSpriteForLeafType(ClientMod.DEFAULT));
        }

        public Particle createParticle(@Nullable SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet spriteSet) {
            return new FallingLeafParticle(world, x, y, z, r, g, b, spriteSet);
        }
    }
}

