/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LeafSettingGenerator
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PackOutput.PathProvider pathProvider;

    public LeafSettingGenerator(PackOutput packOutput) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "fallingleaves/settings");
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return CompletableFuture.supplyAsync(() -> {
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            Consumer<LeafSettingsEntry> consumer = entry -> {
                if (!set.add(entry.id())) {
                    throw new IllegalStateException("Duplicate leaf setting entry " + String.valueOf(entry.id()));
                }
                Path path = this.pathProvider.json(entry.id());
                list.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)entry.serializeToJson(), (Path)path));
            };
            this.registerLeafSettingEntries(consumer);
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    @NotNull
    public String getName() {
        return "leave settings generator";
    }

    protected void registerLeafSettingEntries(Consumer<LeafSettingsEntry> consumer) {
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"jungle_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cherry_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"blue_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"cypress_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"fir_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"orange_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"pine_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"red_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"yellow_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"pink_cherry_leaves"), 1.4));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"skyris_leaves"), 1.4));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"byg", (String)"white_cherry_leaves"), 1.4));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"cypress_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"hemlock_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"redwood_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"japenese_maple_shrub_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"jungle_palm_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"yucca_palm_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"terrestria", (String)"sakura_leaves"), 1.4));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"fir_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"brown_autumnal_leaves"), 1.8));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"orange_autumnal_leaves"), 1.8));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"red_autumnal_leaves"), 1.8));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"traverse", (String)"yellow_autumnal_leaves"), 1.8));
        consumer.accept(new LeafSettingsEntry(ResourceLocation.fromNamespaceAndPath((String)"woods_and_mires", (String)"pine_leaves"), 1.0, true));
    }
}

