/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.util;

import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class Utils {
    public static String genLangKey(String type, String key) {
        return type + ".enchantmentmachine." + key;
    }

    public static Component genTranslation(String type, String key) {
        return Component.translatable((String)Utils.genLangKey(type, key));
    }

    public static int tryApplyEnchantment(EnchantmentInstanceMod enchInst, ItemEnchantments.Mutable existingEnchantments, boolean reducedPrice) {
        if (!(((Boolean)ModConfig.SERVER.allowMixtureEnchantments.get()).booleanValue() || existingEnchantments.keySet().isEmpty() || EnchantmentHelper.isEnchantmentCompatible((Collection)existingEnchantments.keySet(), enchInst.enchantment()))) {
            return -1;
        }
        int level = existingEnchantments.getLevel(enchInst.enchantment());
        if (level > 0) {
            if (level == enchInst.level()) {
                enchInst = new EnchantmentInstanceMod(enchInst.enchantment(), level + 1);
            } else {
                if (level > enchInst.level()) {
                    return -1;
                }
                enchInst = new EnchantmentInstanceMod(enchInst.enchantment(), enchInst.level());
            }
        }
        if (!enchInst.canEnchant()) {
            return -1;
        }
        int cost = enchInst.getEnchantment().definition().maxCost().calculate(enchInst.level());
        if (reducedPrice) {
            cost = Math.max(1, cost / 2);
        }
        existingEnchantments.upgrade(enchInst.enchantment(), enchInst.level());
        return (int)Math.round(Math.abs((double)cost * (Double)ModConfig.SERVER.priceModifier.get()));
    }
}

