/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Unmodifiable;

public class ModConfig {
    public static final Server SERVER;
    private static final ModConfigSpec serverSpec;

    public static void init(IEventBus modbus, ModContainer container) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
        modbus.addListener(SERVER::onConfigLoad);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ModConfigSpec.BooleanValue allowDisenchantingItems;
        public final ModConfigSpec.BooleanValue allowMixtureEnchantments;
        public final ModConfigSpec.ConfigValue<List<? extends String>> maxEnchantmentLevels;
        public final ModConfigSpec.BooleanValue allowDisenchantingCurses;
        public final ModConfigSpec.ConfigValue<List<? extends String>> disallowedDisenchantingEnchantments;
        public final ModConfigSpec.ConfigValue<Double> priceModifier;
        private Set<ResourceLocation> disallowedDisenchantingEnchantmentsMap;
        private Map<ResourceLocation, Integer> maxEnchantmentLevelsMap;

        Server(ModConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.allowDisenchantingItems = builder.comment("Whether items can be disenchanted. More vanilla like would be false").define("allowDisenchantingItems", true);
            this.allowMixtureEnchantments = builder.comment("Whether incompatible enchantments can be allied together").define("allowMixtureEnchantments", false);
            this.maxEnchantmentLevels = builder.comment("Define the max level for applying enchantments. Format is [\"enchantment_id|max_level\",\"enchantment_id|max_level\"]").defineList("maxEnchantmentLevels", Collections.emptyList(), string -> {
                if (string instanceof String) {
                    try {
                        String[] value = ((String)string).split("\\|");
                        ResourceLocation.parse((String)value[0]);
                        Integer.parseInt(value[1]);
                        return true;
                    }
                    catch (ArrayIndexOutOfBoundsException | NumberFormatException | ResourceLocationException e) {
                        return false;
                    }
                }
                return false;
            });
            this.allowDisenchantingCurses = builder.comment(new String[]{"Whether curses can be removed from items", "Only relevant when `allowDisenchantingItems` is enabled"}).define("allowDisenchantingCurses", false);
            this.disallowedDisenchantingEnchantments = builder.comment(new String[]{"List of enchantments that can not be removed from items", "Only relevant when `allowDisenchantingItems` is enabled", "This overrides `allowDisenchantingCurses`"}).defineList("disallowedDisenchantingEnchantments", Collections.emptyList(), this::isResourceLocation);
            this.priceModifier = builder.comment(new String[]{"Multiplies the final price of applying an enchantment", "Set to 0 to disable cost"}).define("priceModifier", (Object)1.0);
            builder.pop();
        }

        private boolean isResourceLocation(Object obj) {
            if (obj instanceof String) {
                String string = (String)obj;
                return ResourceLocation.tryParse((String)string) != null;
            }
            return false;
        }

        public Set<ResourceLocation> getDisallowedDisenchantingEnchantments() {
            return Objects.requireNonNullElse(this.disallowedDisenchantingEnchantmentsMap, Collections.emptySet());
        }

        public @Unmodifiable Map<ResourceLocation, Integer> getMaxEnchantmentLevels() {
            return Objects.requireNonNullElse(this.maxEnchantmentLevelsMap, Collections.emptyMap());
        }

        public void onConfigLoad(ModConfigEvent event) {
            if (serverSpec.isLoaded()) {
                this.disallowedDisenchantingEnchantmentsMap = ((List)this.disallowedDisenchantingEnchantments.get()).stream().map(ResourceLocation::parse).collect(Collectors.toSet());
                this.maxEnchantmentLevelsMap = ((List)this.maxEnchantmentLevels.get()).stream().map(s -> {
                    String[] maxLevels = s.split("\\|");
                    return Pair.of((Object)ResourceLocation.parse((String)maxLevels[0]), (Object)Integer.parseInt(maxLevels[1]));
                }).collect(Collectors.toUnmodifiableMap(Pair::getLeft, Pair::getRight));
            }
        }
    }
}

