/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import de.cheaterpaul.enchantmentmachine.client.gui.components.ContainerList;
import de.cheaterpaul.enchantmentmachine.client.gui.screens.inventory.EnchantmentBaseScreen;
import de.cheaterpaul.enchantmentmachine.inventory.EnchanterContainerMenu;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantingPacket;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class EnchanterScreen
extends EnchantmentBaseScreen<EnchanterContainerMenu> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"enchantmentmachine", (String)"textures/gui/container/enchanter.png");
    private final Map<EnchantmentInstanceMod, Pair<EnchantmentInstanceMod, Integer>> enchantments = new HashMap<EnchantmentInstanceMod, Pair<EnchantmentInstanceMod, Integer>>();
    private ContainerList<EnchantmentItem> list;
    private ItemEnchantments itemEnchantments = ItemEnchantments.EMPTY;

    public EnchanterScreen(EnchanterContainerMenu container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
        this.imageWidth = 232;
        this.imageHeight = 241;
        this.inventoryLabelX = 36;
        this.inventoryLabelY = this.imageHeight - 94;
        container.setListener(this::refreshActiveEnchantments);
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        super.resize(pMinecraft, pWidth, pHeight);
        this.refreshActiveEnchantments();
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(BACKGROUND, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void init() {
        super.init();
        this.list = ContainerList.builder(this.leftPos + 8, this.topPos + 15, this.imageWidth - 70, this.imageHeight - 94 - 17).build();
        this.addRenderableWidget((GuiEventListener)this.list);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.getFocused() == null || !this.isDragging() || pButton != 0 || !this.getFocused().mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return true;
    }

    public void updateEnchantments(Object2IntMap<EnchantmentInstanceMod> enchantments) {
        this.enchantments.clear();
        enchantments.forEach((instance, integer) -> this.enchantments.put((EnchantmentInstanceMod)instance, (Pair<EnchantmentInstanceMod, Integer>)Pair.of((Object)instance, (Object)integer)));
        this.refreshActiveEnchantments();
    }

    public void refreshActiveEnchantments() {
        ItemStack stack = ((EnchanterContainerMenu)this.menu).getSlot(0).getItem();
        this.itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        List availableEnchantments = stack.isEmpty() ? this.enchantments.values().stream().sorted(Comparator.comparing(o -> ((EnchantmentInstanceMod)o.getKey()).getEnchantmentName().getString())).collect(Collectors.toList()) : this.enchantments.values().stream().filter(pair -> stack.getItem() == Items.BOOK || stack.getItem() == Items.ENCHANTED_BOOK || ((EnchantmentInstanceMod)pair.getKey()).getEnchantment().canEnchant(stack)).sorted(Comparator.comparing(o -> ((EnchantmentInstanceMod)o.getKey()).getEnchantmentName().getString())).collect(Collectors.toList());
        this.list.replace(availableEnchantments.stream().map(entry -> new EnchantmentItem((Pair<EnchantmentInstanceMod, Integer>)Pair.of((Object)((EnchantmentInstanceMod)entry.getKey()), (Object)((Integer)entry.getValue())))).collect(Collectors.toList()));
        this.list.clampScrollAmount();
    }

    private void apply(EnchantmentInstanceMod instance) {
        if (((EnchanterContainerMenu)this.menu).getSlot(0).hasItem() && Utils.tryApplyEnchantment(instance, new ItemEnchantments.Mutable(this.itemEnchantments), true) > -1) {
            this.minecraft.player.connection.send((CustomPacketPayload)new EnchantingPacket(Collections.singletonList(instance)));
            Pair<EnchantmentInstanceMod, Integer> value = this.enchantments.get(instance);
            if ((Integer)value.getValue() > 1) {
                this.enchantments.put(instance, (Pair<EnchantmentInstanceMod, Integer>)Pair.of((Object)instance, (Object)((Integer)value.getValue() - 1)));
            } else {
                this.enchantments.remove(instance);
            }
        }
        this.refreshActiveEnchantments();
    }

    private boolean hasEqualEnchantments(ItemEnchantments itemEnchantments, EnchantmentInstanceMod enchantment) {
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            if (((Holder)entry.getKey()).value() != enchantment.getEnchantment() || ((Enchantment)((Holder)entry.getKey()).value()).getMaxLevel() == entry.getIntValue() || entry.getIntValue() > enchantment.level()) continue;
            return true;
        }
        return false;
    }

    private class EnchantmentItem
    extends ContainerList.Entry<EnchantmentItem> {
        private static final WidgetSprites ENCHANT_BUTTON = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward_highlighted"));
        private final ItemStack bookStack;
        private final Component name;
        private final Button button;
        private final AbstractWidget text;
        private final int requiredLevels;
        private final Pair<EnchantmentInstanceMod, Integer> item;
        private final boolean isCompatible;

        public EnchantmentItem(Pair<EnchantmentInstanceMod, Integer> item) {
            this.bookStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK, ((Integer)item.getRight()).intValue());
            this.item = item;
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            mutable.set(((EnchantmentInstanceMod)item.getKey()).enchantment(), ((EnchantmentInstanceMod)item.getKey()).level());
            EnchantmentHelper.setEnchantments((ItemStack)this.bookStack, (ItemEnchantments)mutable.toImmutable());
            this.name = ((EnchantmentInstanceMod)item.getKey()).getEnchantmentName();
            Style style = this.name.getStyle();
            if (style.getColor() == null || style.getColor().getValue() == ChatFormatting.GRAY.getColor().intValue()) {
                ((MutableComponent)this.name).withStyle(style.withColor(ChatFormatting.WHITE));
            }
            this.button = new ImageButton(0, 2, 11, 17, ENCHANT_BUTTON, button -> EnchanterScreen.this.apply((EnchantmentInstanceMod)item.getKey()), (Component)Component.empty());
            this.widgets.add(this.button);
            this.requiredLevels = this.calculateRequiredLevels();
            this.isCompatible = this.isCompatible();
            MutableComponent text = this.isCompatible ? (this.hasSufficientLevels() ? Component.translatable((String)"text.enchantmentmachine.enchant_for_level", (Object[])new Object[]{this.requiredLevels}).withStyle(ChatFormatting.GREEN) : Component.translatable((String)"text.enchantmentmachine.require_level", (Object[])new Object[]{this.requiredLevels}).withStyle(ChatFormatting.YELLOW)) : Component.translatable((String)"text.enchantmentmachine.unavailable").withStyle(ChatFormatting.RED);
            this.button.setTooltip(Tooltip.create((Component)text));
            this.text = new MultiLineTextWidget(this.name, Minecraft.getInstance().font).setMaxWidth(200);
            this.widgets.add(this.text);
            this.text.setPosition(25, 5);
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            GuiEventListener guieventlistener = null;
            for (GuiEventListener guieventlistener1 : List.copyOf(this.children())) {
                if (!guieventlistener1.mouseClicked(pMouseX, pMouseY, pButton)) continue;
                guieventlistener = guieventlistener1;
            }
            if (guieventlistener != null) {
                this.setFocused(guieventlistener);
                if (pButton == 0) {
                    this.setDragging(true);
                }
                return true;
            }
            return false;
        }

        private boolean isCompatible() {
            return Utils.tryApplyEnchantment((EnchantmentInstanceMod)this.item.getKey(), new ItemEnchantments.Mutable(EnchanterScreen.this.itemEnchantments), false) != -1;
        }

        @Override
        public void render(@NotNull GuiGraphics guiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            guiGraphics.blitSprite(WIDGETS_LOCATION.get(true, false), pLeft, pTop, pWidth, pHeight + 5);
            guiGraphics.renderItem(this.bookStack, pLeft + 5, pTop + 1);
            guiGraphics.drawString(EnchanterScreen.this.font, this.name, pLeft + 25, pTop + 5, -1);
            String count = String.valueOf(this.bookStack.getCount());
            guiGraphics.drawString(EnchanterScreen.this.font, count, pLeft + pWidth - 20, pTop + 5, 0xFFFFFF);
            this.button.setPosition(pLeft + pWidth - 12, pTop + 1);
            this.text.setPosition(pLeft + 25, pTop + 5);
            this.button.visible = ((EnchanterContainerMenu)EnchanterScreen.this.menu).getSlot(0).hasItem();
            if (this.isCompatible) {
                if (this.hasSufficientLevels()) {
                    RenderSystem.setShaderColor((float)0.2f, (float)1.0f, (float)0.4f, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)0.5f, (float)0.4f, (float)0.2f, (float)1.0f);
                }
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)0.2f, (float)0.4f, (float)1.0f);
            }
            guiGraphics.pose().pushPose();
            this.button.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
            if (pIsMouseOver && !this.button.isHoveredOrFocused()) {
                EnchanterScreen.this.setTooltipForNextRenderPass(Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)this.bookStack).stream().flatMap(a -> Tooltip.splitTooltip((Minecraft)Minecraft.getInstance(), (Component)a).stream()).toList());
            }
            guiGraphics.pose().popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        private int calculateRequiredLevels() {
            return Utils.tryApplyEnchantment((EnchantmentInstanceMod)this.item.getKey(), new ItemEnchantments.Mutable(EnchanterScreen.this.itemEnchantments), true);
        }

        private boolean hasSufficientLevels() {
            return ((EnchanterContainerMenu)((EnchanterScreen)EnchanterScreen.this).menu).getPlayer().experienceLevel >= this.requiredLevels || ((EnchanterContainerMenu)((EnchanterScreen)EnchanterScreen.this).menu).getPlayer().getAbilities().instabuild;
        }
    }
}

