/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.client.gui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ContainerList<T extends ContainerObjectSelectionList.Entry<T>>
extends ContainerObjectSelectionList<T> {
    public ContainerList(Minecraft pMinecraft, int pWidth, int pHeight, int pY0, int pItemHeight) {
        super(pMinecraft, pWidth, pHeight, pY0, pItemHeight);
    }

    protected void renderDecorations(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        guiGraphics.fillGradient(this.getX(), this.getY(), this.getRight() - 6, this.getY() + 4, -16777216, 0);
        guiGraphics.fillGradient(this.getX(), this.getBottom() - 4, this.getRight() - 6, this.getBottom(), 0, -16777216);
    }

    protected void renderItem(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick, int pIndex, int pLeft, int pTop, int pWidth, int pHeight) {
        super.renderItem(guiGraphics, pMouseX, pMouseY, pPartialTick, pIndex, pLeft, pTop, pWidth - 6, pHeight);
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 6;
    }

    public int getRowWidth() {
        return this.width;
    }

    public int getRowLeft() {
        return super.getRowLeft() - 2;
    }

    protected int getRowTop(int pIndex) {
        return super.getRowTop(pIndex) - 4;
    }

    public int getMaxScroll() {
        return Math.max(0, super.getMaxScroll() - 4);
    }

    public void replace(Collection<T> entries) {
        this.replaceEntries(entries);
    }

    public static <T extends Entry<T>> Builder<T> builder(int x, int y, int pWidth, int pHeight) {
        return new Builder(x, y, pWidth, pHeight);
    }

    public static class Builder<T extends Entry<T>> {
        protected final int x;
        protected final int y;
        protected final int pWidth;
        protected final int pHeight;
        protected int itemHeight = 19;

        public Builder(int x, int y, int pWidth, int pHeight) {
            this.x = x;
            this.y = y;
            this.pWidth = pWidth;
            this.pHeight = pHeight;
        }

        public Builder<T> itemHeight(int itemHeight) {
            this.itemHeight = itemHeight;
            return this;
        }

        public ContainerList<T> build() {
            ContainerList simpleList = new ContainerList(Minecraft.getInstance(), this.pWidth, this.pHeight, this.y, this.itemHeight);
            simpleList.setX(this.x);
            return simpleList;
        }
    }

    public static class Entry<T extends ContainerObjectSelectionList.Entry<T>>
    extends ContainerObjectSelectionList.Entry<T> {
        protected static final WidgetSprites WIDGETS_LOCATION = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
        protected final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();

        public List<? extends NarratableEntry> narratables() {
            return this.widgets;
        }

        public List<? extends GuiEventListener> children() {
            return this.widgets;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
        }

        public int getTextureY(boolean isMouseOver) {
            int i = 1;
            if (isMouseOver) {
                i = 2;
            }
            return 46 + i * 20;
        }
    }
}

