/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block.entity;

import de.cheaterpaul.enchantmentmachine.block.entity.IEnchantmentMachine;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class EnchantmentBaseBlockEntity
extends BaseContainerBlockEntity
implements IEnchantmentMachine {
    @Nullable
    private BlockPos storageBlockPos;

    public EnchantmentBaseBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    public boolean stillValid(@Nonnull Player playerEntity) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return playerEntity.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @Override
    public Optional<StorageBlockEntity> getConnectedEnchantmentTE() {
        if (this.storageBlockPos == null) {
            return Optional.empty();
        }
        BlockEntity te = this.level.getBlockEntity(this.storageBlockPos);
        if (te instanceof StorageBlockEntity) {
            return Optional.of((StorageBlockEntity)te);
        }
        return Optional.empty();
    }

    public void onNeighbourChanged(LevelReader iWorld, BlockPos neighborPos) {
        if (this.storageBlockPos == null) {
            if (iWorld.getBlockState(neighborPos).getBlock() == ModData.storage_block.get()) {
                this.storageBlockPos = neighborPos;
            }
        } else if (this.storageBlockPos.equals((Object)neighborPos) && iWorld.getBlockState(neighborPos).getBlock() != ModData.storage_block.get()) {
            this.storageBlockPos = null;
        }
    }

    @Override
    public boolean hasConnectedTE() {
        return this.storageBlockPos != null;
    }

    protected void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.storageBlockPos != null) {
            compound.putIntArray("storageblock", new int[]{this.storageBlockPos.getX(), this.storageBlockPos.getY(), this.storageBlockPos.getZ()});
        }
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("storageblock")) {
            int[] pos = nbt.getIntArray("storageblock");
            this.storageBlockPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
    }
}

