/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block;

import com.mojang.serialization.MapCodec;
import de.cheaterpaul.enchantmentmachine.block.EnchantmentBaseBlock;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantmentPacket;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentStore;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StorageBlock
extends EnchantmentBaseBlock {
    protected static final VoxelShape SHAPE = StorageBlock.makeShape();
    private static final MapCodec<StorageBlock> CODEC = StorageBlock.simpleCodec(StorageBlock::new);

    public StorageBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ((BlockEntityType)ModData.storage_tile.get()).create(pos, state);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        EnchantmentStore enchantmentStore = (EnchantmentStore)stack.get((DataComponentType)ModData.CONTAINED_ENCHANTMENTS.get());
        if (enchantmentStore != null) {
            tooltip.add((Component)Component.translatable((String)"text.enchantment_block.contained_enchantments", (Object[])new Object[]{enchantmentStore.enchantments().values().stream().mapToInt(x -> x).sum()}));
        }
    }

    public void playerDestroy(@Nonnull Level worldIn, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, @Nonnull ItemStack heldStack) {
        ItemStack stack = new ItemStack((ItemLike)ModData.storage_block.get(), 1);
        if (te instanceof StorageBlockEntity) {
            StorageBlockEntity storage = (StorageBlockEntity)te;
            stack.set((DataComponentType)ModData.CONTAINED_ENCHANTMENTS.get(), (Object)new EnchantmentStore(storage.getAllEnchantments()));
        }
        StorageBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity tile = pLevel.getBlockEntity(pPos);
        if (tile instanceof StorageBlockEntity && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            serverPlayer.connection.send((CustomPacketPayload)new EnchantmentPacket(((StorageBlockEntity)tile).getEnchantments(), true));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return StorageBlock.createStorageTicker(level, type, (BlockEntityType<? extends StorageBlockEntity>)((BlockEntityType)ModData.storage_tile.get()));
    }

    protected static <T extends BlockEntity> BlockEntityTicker<T> createStorageTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends StorageBlockEntity> tile) {
        return level.isClientSide ? StorageBlock.createTickerHelper(type, tile, StorageBlockEntity::clientTick) : null;
    }
}

