package de.cheaterpaul.enchantmentmachine.block;

import com.mojang.serialization.MapCodec;
import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.block.entity.EnchanterBlockEntity;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantmentPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.checkerframework.checker.units.qual.C;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;

public class EnchanterBlock extends EnchantmentBaseBlock {

    protected static final VoxelShape SHAPE = makeShape();
    private static final MapCodec<EnchanterBlock> CODEC = simpleCodec(EnchanterBlock::new);


    public EnchanterBlock(Properties properties) {
        super(properties);
    }

    @Override
    protected @NotNull MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean useShapeForLightOcclusion(@Nonnull BlockState state) {
        return true;
    }

    @Override
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModData.enchanter_tile.get().create(pos, state);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity tile = pLevel.getBlockEntity(pPos);
        if (tile instanceof EnchanterBlockEntity) {
            pPlayer.openMenu(((EnchanterBlockEntity) tile));
            if (!pLevel.isClientSide() && pPlayer instanceof ServerPlayer serverPlayer) {
                Optional<StorageBlockEntity> s = ((EnchanterBlockEntity) tile).getConnectedEnchantmentTE();
                s.ifPresent(enchantmentTileEntity -> serverPlayer.connection.send(new EnchantmentPacket(enchantmentTileEntity.getEnchantments(), false)));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack itemStack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltips, flag);
        tooltips.add(Component.translatable("text.enchantmentmachine.next_to_storage_block", ModData.storage_block.get().getName()).withStyle(ChatFormatting.GRAY));

    }

    @SuppressWarnings("deprecation")
    @Nonnull
    @Override
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        VoxelShape a = Block.box(0.0D, 0.0D, 0.0D, 16.0D, 12.0D, 16.0D);

        VoxelShape b = Block.box(2, 12, 2, 7, 15, 5);

        VoxelShape c = Block.box(9, 12, 11, 14, 15, 14);

        VoxelShape d = Block.box(4, 13, 5, 5, 14, 11);

        VoxelShape e = Block.box(11, 13, 5, 12, 14, 11);

        return Shapes.or(a,b,c,d,e);
    }
}
