/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.autoelytraflight;

import com.mojang.blaze3d.platform.InputConstants;
import de.cheaterpaul.autoelytraflight.ElytraConfig;
import de.cheaterpaul.autoelytraflight.GraphDataPoint;
import java.util.LinkedList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

public class ClientTicker {
    private boolean autoFlight;
    private Vec3 previousPosition;
    private double currentVelocity;
    public boolean isDescending;
    public boolean pullUp;
    public boolean pullDown;
    private boolean lastPressed = false;
    public boolean showHud;
    public String[] hudString;
    private final Minecraft mc;
    private static final KeyMapping keyBinding = new KeyMapping("key.autoelytraflight.toggle", InputConstants.Type.KEYSYM, 82, "text.autoelytraflight.title");
    public LinkedList<GraphDataPoint> graph = new LinkedList();
    private double totalHorizontalDelta = 0.0;

    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(keyBinding);
    }

    public ClientTicker() {
        this.mc = Minecraft.getInstance();
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        if (this.mc.player != null) {
            if (this.mc.player.isFallFlying()) {
                this.showHud = true;
            } else {
                this.showHud = false;
                this.autoFlight = false;
            }
            if (!this.lastPressed && keyBinding.isDown() && this.mc.player != null && this.mc.player.isFallFlying()) {
                boolean bl = this.autoFlight = !this.autoFlight;
                if (this.autoFlight) {
                    this.isDescending = true;
                }
            }
            this.lastPressed = keyBinding.isDown();
            if (this.autoFlight) {
                if (this.isDescending) {
                    this.pullUp = false;
                    this.pullDown = true;
                    if (this.currentVelocity >= (Double)ElytraConfig.CONFIG.pullDownMaxVelocity.get()) {
                        this.isDescending = false;
                        this.pullDown = false;
                        this.pullUp = true;
                    }
                } else {
                    this.pullUp = true;
                    this.pullDown = false;
                    if (this.currentVelocity <= (Double)ElytraConfig.CONFIG.pullUpMinVelocity.get()) {
                        this.isDescending = true;
                        this.pullDown = true;
                        this.pullUp = false;
                    }
                }
                if (this.pullUp) {
                    this.mc.player.setXRot((float)((double)this.mc.player.getXRot() - (Double)ElytraConfig.CONFIG.pullUpSpeed.get()));
                    if ((double)this.mc.player.getXRot() <= (Double)ElytraConfig.CONFIG.pullUpAngle.get()) {
                        this.mc.player.setXRot(((Double)ElytraConfig.CONFIG.pullUpAngle.get()).floatValue());
                    }
                }
                if (this.pullDown) {
                    this.mc.player.setXRot((float)((double)this.mc.player.getXRot() + (Double)ElytraConfig.CONFIG.pullDownSpeed.get()));
                    if ((double)this.mc.player.getXRot() >= (Double)ElytraConfig.CONFIG.pullDownAngle.get()) {
                        this.mc.player.setXRot(((Double)ElytraConfig.CONFIG.pullDownAngle.get()).floatValue());
                    }
                }
            } else {
                this.pullUp = false;
                this.pullDown = false;
            }
            if (this.showHud) {
                this.computeVelocity();
                double altitude = this.mc.player.position().y;
                if (this.hudString == null) {
                    this.hudString = new String[3];
                }
                this.hudString[0] = "Auto flight : " + (this.autoFlight ? "Enabled" : "Disabled");
                this.hudString[1] = "Altitude : " + String.format("%.2f", altitude);
                this.hudString[2] = "Speed : " + String.format("%.2f", this.currentVelocity * 20.0) + " m/s";
                GraphDataPoint newDataPoint = this.graph.size() > 0 ? new GraphDataPoint(this.mc.player.position(), this.graph.getLast().realPosition) : new GraphDataPoint(this.mc.player.position());
                newDataPoint.pullUp = this.pullUp;
                newDataPoint.pullDown = this.pullDown;
                newDataPoint.velocity = this.currentVelocity;
                this.addLastDataPoint(newDataPoint);
            } else {
                this.clearGraph();
            }
        }
    }

    private void addLastDataPoint(GraphDataPoint p) {
        this.graph.addLast(p);
        this.totalHorizontalDelta += p.horizontalDelta;
        while (this.totalHorizontalDelta > (double)((Integer)ElytraConfig.CONFIG.guiGraphRealWidth.get()).intValue()) {
            this.removeFirstDataPoint();
        }
    }

    private void removeFirstDataPoint() {
        this.graph.removeFirst();
        this.totalHorizontalDelta -= this.graph.getFirst().horizontalDelta;
    }

    private void clearGraph() {
        this.graph.clear();
        this.totalHorizontalDelta = 0.0;
    }

    private void computeVelocity() {
        Vec3 newPosition = this.mc.player.position();
        if (this.previousPosition == null) {
            this.previousPosition = newPosition;
        }
        Vec3 difference = new Vec3(newPosition.x - this.previousPosition.x, newPosition.y - this.previousPosition.y, newPosition.z - this.previousPosition.z);
        this.previousPosition = newPosition;
        this.currentVelocity = difference.length() > 0.0 ? difference.length() : this.currentVelocity;
    }
}

