/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.autoelytraflight;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.cheaterpaul.autoelytraflight.ClientTicker;
import de.cheaterpaul.autoelytraflight.ElytraConfig;
import de.cheaterpaul.autoelytraflight.GraphDataPoint;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.common.NeoForge;

public class InGameHud
implements LayeredDraw.Layer {
    private final Minecraft minecraftClient;
    private final ClientTicker ticker;

    public static void registerOverlay(RegisterGuiLayersEvent event) {
        ClientTicker clientTicker = new ClientTicker();
        NeoForge.EVENT_BUS.register((Object)clientTicker);
        event.registerAboveAll(new ResourceLocation("autoelytraflight", "elytra-statistics"), (LayeredDraw.Layer)new InGameHud(clientTicker));
    }

    public InGameHud(ClientTicker ticker) {
        this.ticker = ticker;
        this.minecraftClient = Minecraft.getInstance();
    }

    public void render(GuiGraphics guiGraphics, float partialTicks) {
        if (this.ticker.showHud) {
            if (this.ticker.hudString != null) {
                float stringX = ((Integer)ElytraConfig.CONFIG.guiX.get()).intValue();
                float stringY = (Integer)ElytraConfig.CONFIG.guiY.get() + (Integer)ElytraConfig.CONFIG.guiHeight.get() + 2;
                for (int i = 0; i < this.ticker.hudString.length; ++i) {
                    guiGraphics.drawString(this.minecraftClient.font, this.ticker.hudString[i], stringX, stringY, 0xFFFFFF, true);
                    Objects.requireNonNull(this.minecraftClient.font);
                    stringY += (float)(9 + 1);
                }
            }
            if (((Boolean)ElytraConfig.CONFIG.showGraph.get()).booleanValue()) {
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                guiGraphics.fill(((Integer)ElytraConfig.CONFIG.guiX.get()).intValue(), ((Integer)ElytraConfig.CONFIG.guiY.get()).intValue(), (Integer)ElytraConfig.CONFIG.guiX.get() + (Integer)ElytraConfig.CONFIG.guiWidth.get(), (Integer)ElytraConfig.CONFIG.guiY.get() + (Integer)ElytraConfig.CONFIG.guiHeight.get(), 0x22FFFFFF);
                double maxAltitude = 0.0;
                double minAltitude = 999.0;
                for (GraphDataPoint p : this.ticker.graph) {
                    if (p.realPosition.y > maxAltitude) {
                        maxAltitude = p.realPosition.y;
                    }
                    if (!(p.realPosition.y < minAltitude)) continue;
                    minAltitude = p.realPosition.y;
                }
                if (maxAltitude > 0.0) {
                    MultiBufferSource.BufferSource bufferSource = this.minecraftClient.renderBuffers().bufferSource();
                    maxAltitude += 5.0;
                    minAltitude -= 40.0;
                    VertexConsumer consumer = this.beginDrawLineColor((MultiBufferSource)bufferSource);
                    double currentX = 0.0;
                    for (GraphDataPoint p : this.ticker.graph) {
                        double currentY = (p.realPosition.y - minAltitude) * (double)((Integer)ElytraConfig.CONFIG.guiHeight.get()).intValue() / (maxAltitude - minAltitude);
                        double screenX = (double)((Integer)ElytraConfig.CONFIG.guiX.get()).intValue() + currentX;
                        double screenY = (double)((Integer)ElytraConfig.CONFIG.guiY.get() + (Integer)ElytraConfig.CONFIG.guiHeight.get()) - currentY;
                        float speedRatio = (float)p.velocity / 3.0f;
                        float r = 2.0f * (1.0f - speedRatio);
                        float g = 2.0f * speedRatio;
                        if (r > 1.0f) {
                            r = 1.0f;
                        }
                        if (g > 1.0f) {
                            g = 1.0f;
                        }
                        if (r < 0.0f) {
                            r = 0.0f;
                        }
                        if (g < 0.0f) {
                            g = 0.0f;
                        }
                        this.addLinePointColor(pose, consumer, (float)screenX, (float)screenY, 0.0f, 1.0f, r, g, 0.0f);
                        currentX += p.horizontalDelta * (double)((Integer)ElytraConfig.CONFIG.guiWidth.get() - 1) / (double)((Integer)ElytraConfig.CONFIG.guiGraphRealWidth.get()).intValue();
                    }
                    this.endDrawLine(bufferSource);
                    VertexConsumer consumer1 = this.beginDrawLine(bufferSource, -16777216);
                    this.addLinePointColor(pose, consumer1, ((Integer)ElytraConfig.CONFIG.guiX.get()).intValue(), ((Integer)ElytraConfig.CONFIG.guiY.get()).intValue(), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                    this.addLinePointColor(pose, consumer1, ((Integer)ElytraConfig.CONFIG.guiX.get()).intValue(), (Integer)ElytraConfig.CONFIG.guiY.get() + (Integer)ElytraConfig.CONFIG.guiHeight.get(), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                    this.addLinePointColor(pose, consumer1, (Integer)ElytraConfig.CONFIG.guiX.get() + (Integer)ElytraConfig.CONFIG.guiWidth.get(), (Integer)ElytraConfig.CONFIG.guiY.get() + (Integer)ElytraConfig.CONFIG.guiHeight.get(), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                    this.addLinePointColor(pose, consumer1, (Integer)ElytraConfig.CONFIG.guiX.get() + (Integer)ElytraConfig.CONFIG.guiWidth.get(), ((Integer)ElytraConfig.CONFIG.guiY.get()).intValue(), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                    this.addLinePointColor(pose, consumer1, ((Integer)ElytraConfig.CONFIG.guiX.get()).intValue(), ((Integer)ElytraConfig.CONFIG.guiY.get()).intValue(), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                    this.endDrawLine(bufferSource);
                }
                pose.popPose();
            }
        }
    }

    private VertexConsumer beginDrawLine(MultiBufferSource.BufferSource bufferSource, int color) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        return bufferSource.getBuffer(RenderType.debugLineStrip((double)1.0));
    }

    private VertexConsumer beginDrawLineColor(MultiBufferSource bufferSource) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        return bufferSource.getBuffer(RenderType.debugLineStrip((double)1.0));
    }

    private void addLinePointColor(PoseStack poseStack, VertexConsumer consumer, float x, float y, float z, float a, float r, float g, float b) {
        consumer.vertex(poseStack.last().pose(), x, y, z).color(r, g, b, a).endVertex();
    }

    private void endDrawLine(MultiBufferSource.BufferSource source) {
        source.endLastBatch();
        RenderSystem.disableBlend();
    }
}

